/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.repository.interceptor;

import com.bizunited.nebula.common.repository.interceptor.NebulaRepositoryInterceptorStrategy;
import com.bizunited.nebula.common.repository.interceptor.SqlCommandType;
import com.bizunited.nebula.common.util.SqlUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Intercepts(value={@Signature(method="prepare", type=StatementHandler.class, args={Connection.class, Integer.class})})
public class MybatisInterceptor
implements Interceptor {
    @Autowired(required=false)
    private List<NebulaRepositoryInterceptorStrategy> repositoryInterceptorStrategies;
    private static final Logger LOGGER = LoggerFactory.getLogger(MybatisInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        if (!(invocation.getTarget() instanceof StatementHandler)) {
            return invocation.proceed();
        }
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        Connection currentConnection = (Connection)invocation.getArgs()[0];
        MetaObject metaObject = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
        MappedStatement mappedStatement = null;
        try {
            mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        }
        catch (RuntimeException e) {
            Plugin plugin = (Plugin)metaObject.getValue("h");
            metaObject = MetaObject.forObject((Object)plugin, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
            statementHandler = (StatementHandler)metaObject.getValue("target");
            mappedStatement = (MappedStatement)metaObject.getValue("target.delegate.mappedStatement");
        }
        if (CollectionUtils.isEmpty(this.repositoryInterceptorStrategies)) {
            return invocation.proceed();
        }
        BoundSql boundSql = statementHandler.getBoundSql();
        String sql = SqlUtils.formatSql(boundSql);
        List sortedNebulaRepositoryInterceptorStrategies = this.repositoryInterceptorStrategies.stream().sorted((source, target) -> source.sort() - target.sort()).collect(Collectors.toList());
        block10: for (NebulaRepositoryInterceptorStrategy repositoryInterceptorStrategy : sortedNebulaRepositoryInterceptorStrategies) {
            switch (mappedStatement.getSqlCommandType()) {
                case DELETE: {
                    sql = repositoryInterceptorStrategy.intercept(SqlCommandType.DELETE, sql, currentConnection);
                    continue block10;
                }
                case INSERT: {
                    sql = repositoryInterceptorStrategy.intercept(SqlCommandType.INSERT, sql, currentConnection);
                    continue block10;
                }
                case UPDATE: {
                    sql = repositoryInterceptorStrategy.intercept(SqlCommandType.UPDATE, sql, currentConnection);
                    continue block10;
                }
                case SELECT: {
                    sql = repositoryInterceptorStrategy.intercept(SqlCommandType.SELECT, sql, currentConnection);
                    continue block10;
                }
            }
        }
        try {
            Field field = boundSql.getClass().getDeclaredField("sql");
            field.setAccessible(true);
            field.set(boundSql, sql);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }
}

