/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.service.ccode;

import com.bizunited.nebula.common.service.ccode.CheckCodeService;
import com.bizunited.nebula.common.service.vcode.ValidateCodeService;
import com.bizunited.nebula.common.service.vcode.ValidateCodeType;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Random;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultCheckCodeServiceImpl
implements CheckCodeService {
    private static final String CHECKCODE_SUBSYSTEM = "loginCheck";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCheckCodeServiceImpl.class);
    @Autowired
    private ValidateCodeService validateCodeService;

    @Override
    public byte[] generate(String userid, int size, int width, int height) {
        String currentCode = this.validateCodeService.generate(userid, CHECKCODE_SUBSYSTEM, size, ValidateCodeType.IGNORE_CHAR, 300000);
        int currentSize = currentCode.length();
        BufferedImage buffImg = new BufferedImage(width, height, 1);
        Graphics2D graphics = buffImg.createGraphics();
        graphics.setColor(new Color(240, 240, 240));
        graphics.fillRect(0, 0, width, height);
        Font currentFont = new Font("Arial", 2, (int)((float)height * 0.75f));
        graphics.setFont(currentFont);
        int preWidth = width / (currentSize + 2);
        for (int index = 0; index < currentSize; ++index) {
            Character currentChar = Character.valueOf(currentCode.charAt(index));
            graphics.setColor(this.getRandomColor());
            graphics.drawString(currentChar.toString(), (index + 1) * preWidth, (int)((double)height * 0.75));
        }
        Random pointRandom = new Random();
        for (int i = 0; i < 10; ++i) {
            graphics.setColor(this.getRandomColor());
            graphics.drawLine(pointRandom.nextInt(width / 2), pointRandom.nextInt(height / 2), pointRandom.nextInt(width), pointRandom.nextInt(height));
        }
        int many = width * height / 3;
        for (int i = 0; i < many; ++i) {
            graphics.setColor(this.getRandomColor());
            graphics.fillRect(pointRandom.nextInt(width), pointRandom.nextInt(height), 1, 1);
        }
        byte[] result = null;
        try (ByteArrayOutputStream boutput = new ByteArrayOutputStream();
             BufferedOutputStream bos = new BufferedOutputStream(boutput);){
            ImageIO.write((RenderedImage)buffImg, "png", bos);
            result = boutput.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public String generateByBase64(String userid, int size, int width, int height) {
        byte[] contents = this.generate(userid, size, width, height);
        if (contents == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(contents);
    }

    @Override
    public boolean match(String userid, String original) {
        if (StringUtils.isBlank((CharSequence)userid)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)original)) {
            return false;
        }
        return this.validateCodeService.match(userid, CHECKCODE_SUBSYSTEM, original);
    }

    private Color getRandomColor() {
        Random random = new Random();
        int r = random.nextInt(255);
        int g = random.nextInt(255);
        int b = random.nextInt(255);
        return new Color(r, g, b);
    }
}

