/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.service.mongo;

import com.bizunited.nebula.common.interceptor.MongoQueryInterceptorStrategy;
import com.bizunited.nebula.common.service.mongo.MongoQueryService;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MongoQueryServiceImpl
implements MongoQueryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoQueryServiceImpl.class);
    @Autowired(required=false)
    private List<MongoQueryInterceptorStrategy> queryInterceptorStrategies;
    @Autowired(required=false)
    private MongoTemplate mongoTemplate;

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass) {
        return this.find(query, entityClass, this.mongoTemplate.getCollectionName(entityClass));
    }

    @Override
    public <T> List<T> find(Query query, Class<T> entityClass, String collectionName) {
        Validate.notNull((Object)query, (String)"Query must not be null!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)collectionName, (String)"CollectionName must not be null!", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.queryInterceptorStrategies)) {
            List<MongoQueryInterceptorStrategy> sortedMongoQueryInterceptorStrategies = this.queryInterceptorStrategies.stream().sorted(Comparator.comparingInt(MongoQueryInterceptorStrategy::sort)).collect(Collectors.toList());
            sortedMongoQueryInterceptorStrategies.forEach(strategy -> strategy.intercept(query, collectionName));
        }
        return this.mongoTemplate.find(query, entityClass, collectionName);
    }

    @Override
    public <T> List<T> findDistinct(Query query, String field, Class<?> entityClass, Class<T> resultClass) {
        return this.findDistinct(query, field, this.mongoTemplate.getCollectionName(entityClass), entityClass, resultClass);
    }

    @Override
    public <T> List<T> findDistinct(Query query, String field, String collectionName, Class<?> entityClass, Class<T> resultClass) {
        Validate.notNull((Object)query, (String)"Query must not be null!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)collectionName, (String)"CollectionName must not be null!", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.queryInterceptorStrategies)) {
            List<MongoQueryInterceptorStrategy> sortedMongoQueryInterceptorStrategies = this.queryInterceptorStrategies.stream().sorted(Comparator.comparingInt(MongoQueryInterceptorStrategy::sort)).collect(Collectors.toList());
            sortedMongoQueryInterceptorStrategies.forEach(strategy -> strategy.intercept(query, collectionName));
        }
        return this.mongoTemplate.findDistinct(query, field, collectionName, entityClass, resultClass);
    }

    @Override
    public long count(Query query, Class<?> entityClass) {
        return this.count(query, entityClass, this.mongoTemplate.getCollectionName(entityClass));
    }

    @Override
    public long count(Query query, String collectionName) {
        return this.count(query, null, collectionName);
    }

    @Override
    public long count(Query query, Class<?> entityClass, String collectionName) {
        Validate.notBlank((CharSequence)collectionName, (String)"Collection name must not be null or empty!", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.queryInterceptorStrategies)) {
            List<MongoQueryInterceptorStrategy> sortedMongoQueryInterceptorStrategies = this.queryInterceptorStrategies.stream().sorted(Comparator.comparingInt(MongoQueryInterceptorStrategy::sort)).collect(Collectors.toList());
            sortedMongoQueryInterceptorStrategies.forEach(strategy -> strategy.intercept(query, collectionName));
        }
        return this.mongoTemplate.count(query, entityClass, collectionName);
    }

    @Override
    public List<String> getCollectionFieldNames(String collectionName) {
        Document firstDoc = (Document)this.mongoTemplate.getCollection(collectionName).find().first();
        if (Objects.isNull(firstDoc)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)firstDoc.keySet());
    }
}

