/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.service.vcode;

import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.service.sms.SmsService;
import com.bizunited.nebula.common.service.vcode.ValidateCodeService;
import com.bizunited.nebula.common.service.vcode.ValidateCodeType;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class DefaultValidateCodeServiceImpl
implements ValidateCodeService {
    private static final int MAX_DEC = 99999999;
    private static final String MATCH_LETTERS = "^[a-z|A-Z]+$";
    private static final String VCODE_LOCK_CYCLE_PREFIX = "VCODE_LOCK_CYCLE_";
    private static final String VCODE_SEND_CYCLE_PREFIX = "VCODE_SEND_CYCLE_";
    private static final String VCODE_PREFIX = "_VCODE_";
    private static final char[] validate_chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] validate_ignore_chars = new char[]{'A', 'a', 'B', 'b', 'C', 'c', 'D', 'd', 'E', 'e', 'F', 'f', 'G', 'g', 'H', 'g', 'I', 'i', 'J', 'j', 'K', 'k', 'L', 'M', 'm', 'N', 'n', 'P', 'p', 'Q', 'q', 'R', 'r', 'S', 's', 'T', 't', 'U', 'u', 'V', 'v', 'W', 'w', 'X', 'x', 'Y', 'y', 'Z', 'z', '2', '3', '4', '5', '6', '7', '8', '9'};
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private SmsService smsService;

    @Override
    public String generate(String userid, String subSystem, int size, ValidateCodeType codeType, int timeout) {
        String currentString;
        this.validate(userid, size, codeType, timeout);
        String currentsSubSystem = this.validateSubSystem(subSystem);
        Random currentRandom = new Random();
        if (codeType == ValidateCodeType.NUMERICAL) {
            Integer currentValue = currentRandom.nextInt(99999999);
            currentString = currentValue.toString();
            currentString = StringUtils.substring((String)currentString, (int)0, (int)size);
        } else if (codeType == ValidateCodeType.CHAR) {
            currentString = this.generateChars(size);
        } else if (codeType == ValidateCodeType.IGNORE_CHAR) {
            currentString = this.generateIgnoreChars(size);
        } else {
            throw new IllegalArgumentException("\u76ee\u524d\u6682\u4e0d\u652f\u6301\u5f53\u524d\u9009\u62e9\u7684\u9a8c\u8bc1\u7801\u751f\u6210\u6837\u5f0f\uff01\uff01");
        }
        String mapName = StringUtils.join((Object[])new String[]{VCODE_PREFIX, userid});
        this.redisMutexService.setMCode(mapName, currentsSubSystem, currentString, timeout);
        return currentString;
    }

    private String generateChars(int size) {
        StringBuilder result = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < size; ++i) {
            result.append(validate_chars[random.nextInt(validate_chars.length)]);
        }
        return result.toString();
    }

    private String generateIgnoreChars(int size) {
        StringBuilder result = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < size; ++i) {
            result.append(validate_ignore_chars[random.nextInt(validate_ignore_chars.length)]);
        }
        return result.toString();
    }

    private void validate(String userid, int size, ValidateCodeType codeType, int timeout) {
        Validate.notBlank((CharSequence)userid, (String)"\u4f7f\u7528\u9a8c\u8bc1\u7801\u751f\u6210\u670d\u52a1\u65f6\uff0c\u7528\u6237\u6807\u8bc6\u5fc5\u987b\u4f20\u5165\uff01\uff01", (Object[])new Object[0]);
        Validate.isTrue((size >= 4 && size <= 8 ? 1 : 0) != 0, (String)"\u9a8c\u8bc1\u7801\u4f4d\u6570\u5fc5\u987b\u4ecb\u4e8e4\u4f4d\u2014\u20148\u4f4d\u4e4b\u95f4\uff01\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)codeType), (String)"\u4f7f\u7528\u9a8c\u8bc1\u7801\u751f\u6210\u670d\u52a1\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u9a8c\u8bc1\u7801\u6837\u5f0f\u6548\u679c\uff08\u6570\u5b57\u3001\u5b57\u6bcd+\u6570\u5b57\uff09\uff01\uff01", (Object[])new Object[0]);
        Validate.isTrue((timeout > 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u9a8c\u8bc1\u7801\u751f\u6210\u670d\u52a1\u65f6\uff0c\u5fc5\u987b\u4e3a\u9a8c\u8bc1\u7801\u6307\u5b9a\u6b63\u786e\u7684\u6709\u6548\u671f\uff08\u5927\u4e8e\u96f6\u7684\u6beb\u79d2\u6570\uff09\uff01\uff01", (Object[])new Object[0]);
    }

    private String validateSubSystem(String subSystem) {
        String currentsSubSystem = StringUtils.isBlank((CharSequence)subSystem) ? "root" : subSystem;
        Pattern pattern = Pattern.compile(MATCH_LETTERS);
        Validate.isTrue((boolean)pattern.matcher(currentsSubSystem).matches(), (String)"\u4e1a\u52a1\u6a21\u5757\u540d\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\uff01\uff01", (Object[])new Object[0]);
        return currentsSubSystem;
    }

    @Override
    public String generate(String userid, String subSystem, int size, int timeout) {
        return this.generate(userid, subSystem, size, ValidateCodeType.NUMERICAL, timeout);
    }

    @Override
    public String generate(String userid, String subSystem, int timeout) {
        return this.generate(userid, subSystem, 6, ValidateCodeType.NUMERICAL, timeout);
    }

    @Override
    public boolean match(String userid, String subSystem, String original) {
        if (StringUtils.isBlank((CharSequence)userid)) {
            return false;
        }
        String currentsSubSystem = this.validateSubSystem(subSystem);
        if (StringUtils.isBlank((CharSequence)original)) {
            return false;
        }
        String target = this.findByUserAndSubSystem(userid, currentsSubSystem);
        return StringUtils.equalsIgnoreCase((CharSequence)original, (CharSequence)target);
    }

    @Override
    public String findByUserAndSubSystem(String userid, String subSystem) {
        Validate.notBlank((CharSequence)userid, (String)"\u4f7f\u7528\u9a8c\u8bc1\u7801\u751f\u6210\u670d\u52a1\u65f6\uff0c\u7528\u6237\u6807\u8bc6\u5fc5\u987b\u4f20\u5165\uff01\uff01", (Object[])new Object[0]);
        String currentsSubSystem = this.validateSubSystem(subSystem);
        String mapName = StringUtils.join((Object[])new String[]{VCODE_PREFIX, userid});
        return this.redisMutexService.getMCode(mapName, currentsSubSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String send(String phone, String userid, String subSystem, int size, ValidateCodeType codeType, int timeout) {
        Validate.notBlank((CharSequence)phone, (String)"\u7535\u8bdd\u53f7\u7801\u5fc5\u987b\u586b\u5199\uff01\uff01", (Object[])new Object[0]);
        this.validate(userid, size, codeType, timeout);
        String currentsSubSystem = this.validateSubSystem(subSystem);
        int currentTimeout = timeout < 300000 ? 300000 : timeout;
        String cycleMapName = StringUtils.join((Object[])new String[]{VCODE_SEND_CYCLE_PREFIX, userid});
        String cycleMapKey = currentsSubSystem;
        String cycleValue = StringUtils.join((Object[])new String[]{userid, "_", currentsSubSystem});
        String currentCycleValue = this.redisMutexService.getMCode(cycleMapName, cycleMapKey);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)currentCycleValue), (String)"\u8ddd\u79bb\u4e0a\u6b21\u53d1\u9001\u4e0d\u8db360\u79d2\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u9a8c\u8bc1\u7801\u4fe1\u606f\u91cd\u53d1\uff0c\u8bf7\u7a0d\u540e\uff01\uff01", (Object[])new Object[0]);
        String lockKey = StringUtils.join((Object[])new String[]{VCODE_LOCK_CYCLE_PREFIX, userid, "_", currentsSubSystem});
        String verificationCode = null;
        try {
            this.redisMutexService.lock(lockKey);
            currentCycleValue = this.redisMutexService.getMCode(cycleMapName, cycleMapKey);
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)currentCycleValue), (String)"\u8ddd\u79bb\u4e0a\u6b21\u53d1\u9001\u4e0d\u8db360\u79d2\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u9a8c\u8bc1\u7801\u4fe1\u606f\u91cd\u53d1\uff0c\u8bf7\u7a0d\u540e\uff01\uff01", (Object[])new Object[0]);
            verificationCode = this.findByUserAndSubSystem(userid, currentsSubSystem);
            if (StringUtils.isBlank((CharSequence)verificationCode)) {
                verificationCode = this.generate(userid, currentsSubSystem, size, codeType, currentTimeout);
            }
            Validate.notBlank((CharSequence)verificationCode, (String)"\u9a8c\u8bc1\u7801\u751f\u6210\u8fc7\u7a0b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
            this.redisMutexService.setMCode(cycleMapName, cycleMapKey, cycleValue, 60000L);
            String content = "{\"code\":\"" + verificationCode + "\"}";
            Assert.isTrue((boolean)false, (String)"\u3010\u672a\u77e5\u77ed\u4fe1\u7c7b\u578b\u3011\u5f53\u524d\u4e0d\u652f\u6301\u6b64\u77ed\u4fe1\u7c7b\u578b!");
        }
        finally {
            this.redisMutexService.unlock(lockKey);
        }
        return verificationCode;
    }
}

