/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class PageUtils {
    private PageUtils() {
        throw new IllegalStateException("\u9759\u6001\u5de5\u5177\u7c7b\u4e0d\u652f\u6301\u5b9e\u4f8b\u5316");
    }

    public static <T> Page<T> convert2Page(JSONObject json, TypeReference<List<T>> typeReference) {
        if (json == null) {
            return Page.empty((Pageable)PageRequest.of((int)0, (int)50));
        }
        JSONObject pageableJson = json.getJSONObject("pageable");
        int pageNumber = 0;
        int pageSize = 50;
        if (pageableJson != null) {
            pageNumber = pageableJson.getIntValue("pageNumber");
            pageSize = pageableJson.getIntValue("pageSize");
        }
        if (pageSize == 0) {
            pageSize = 50;
        }
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        long total = json.getLongValue("totalElements");
        JSONArray content = json.getJSONArray("content");
        List<Object> list = JsonUtils.convert((Object)content, typeReference);
        list = list == null ? Lists.newArrayList() : list;
        return new PageImpl((List)list, (Pageable)pageable, total);
    }
}

