/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.client.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.venus.client.sdk.register.PhotoWallRegister;
import com.bizunited.nebula.venus.client.sdk.service.PhotoWallService;
import com.bizunited.nebula.venus.client.sdk.vo.PhotoWallRegisterForm;
import com.bizunited.nebula.venus.sdk.service.PhotoWallDocumentService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PhotoWallServiceImpl
implements PhotoWallService {
    @Autowired
    private PhotoWallDocumentService photoWallDocumentService;
    @Autowired(required=false)
    private List<PhotoWallRegister<? extends PhotoWallRegisterForm>> photoWallRegisters;

    public void up(String[] fileCodes, PhotoWallRegisterForm form) {
        String currentPhotoWallRegisterCode = this.validate(fileCodes, form);
        this.photoWallDocumentService.up(fileCodes, currentPhotoWallRegisterCode, (JSONObject)JSONObject.toJSON((Object)form));
    }

    private String validate(String[] fileCodes, PhotoWallRegisterForm form) {
        Validate.notNull((Object)form, (String)"\u9519\u8bef\u7684\u7167\u7247\u5899\u5185\u5bb9\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String billCode = form.getBillCode();
        Validate.notBlank((CharSequence)billCode, (String)"\u9519\u8bef\u7684\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String currentPhotoWallRegisterCode = null;
        Validate.isTrue((!CollectionUtils.isEmpty(this.photoWallRegisters) ? 1 : 0) != 0, (String)"\u5728\u5f53\u524d\u5e94\u7528\u7a0b\u5e8f\u4e2d\uff0c\u672a\u627e\u5230\u4efb\u4f55\u7167\u7247\u5899\u6ce8\u518c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (PhotoWallRegister<? extends PhotoWallRegisterForm> photoWallRegister : this.photoWallRegisters) {
            if (photoWallRegister.formClass() != form.getClass()) continue;
            currentPhotoWallRegisterCode = photoWallRegister.code();
            break;
        }
        Validate.notBlank(currentPhotoWallRegisterCode, (String)"\u5728\u5f53\u524d\u5e94\u7528\u7a0b\u5e8f\u4e2d\uff0c\u672a\u627e\u5230\u4efb\u4f55\u7167\u7247\u5899\u6ce8\u518c\u4fe1\u606f(code)\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((fileCodes != null && fileCodes.length > 0 ? 1 : 0) != 0, (String)"\u56fe\u7247\u9644\u4ef6\u7f16\u53f7\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        return currentPhotoWallRegisterCode;
    }

    public void reUp(String[] fileCodes, PhotoWallRegisterForm form) {
        String currentPhotoWallRegisterCode = this.validate(fileCodes, form);
        this.photoWallDocumentService.reUp(fileCodes, currentPhotoWallRegisterCode, (JSONObject)JSONObject.toJSON((Object)form));
    }

    public void dismiss(String code, String billCode) {
        Validate.notBlank((CharSequence)billCode, (String)"\u5fc5\u987b\u4f20\u5165\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)code, (String)"\u5fc5\u987b\u4f20\u5165\u7167\u7247\u5899\u7c7b\u578b\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.photoWallRegisters) ? 1 : 0) != 0, (String)"\u5728\u5f53\u524d\u5e94\u7528\u7a0b\u5e8f\u4e2d\uff0c\u672a\u627e\u5230\u4efb\u4f55\u7167\u7247\u5899\u6ce8\u518c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        boolean found = false;
        for (PhotoWallRegister<? extends PhotoWallRegisterForm> photoWallRegister : this.photoWallRegisters) {
            if (!StringUtils.equals((CharSequence)photoWallRegister.code(), (CharSequence)code)) continue;
            found = true;
            break;
        }
        Validate.isTrue((boolean)found, (String)"\u672a\u5728\u5f53\u524d\u5e94\u7528\u7a0b\u5e8f\u4e2d\u53d1\u73b0\u6307\u5b9a\u7684\u7167\u7247\u5899\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.photoWallDocumentService.dismiss(code, billCode);
    }
}

