/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.client.local.init;

import com.bizunited.nebula.init.service.InitProcessEnvironmentService;
import com.bizunited.nebula.venus.client.sdk.annotation.EsFieldType;
import com.bizunited.nebula.venus.client.sdk.annotation.PhotoWallField;
import com.bizunited.nebula.venus.client.sdk.register.PhotoWallRegister;
import com.bizunited.nebula.venus.client.sdk.vo.PhotoWallRegisterForm;
import com.bizunited.nebula.venus.sdk.service.PhotoWallRegisterService;
import com.bizunited.nebula.venus.sdk.vo.PhotoWallDocumentStructureFieldVo;
import com.bizunited.nebula.venus.sdk.vo.PhotoWallDocumentStructureVo;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PhotoWallRegisterValidateInit
implements InitProcessEnvironmentService {
    @Autowired
    private PhotoWallRegisterService photoWallRegisterService;
    @Autowired(required=false)
    private List<PhotoWallRegister<? extends PhotoWallRegisterForm>> photoWallRegisters;
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotoWallRegisterValidateInit.class);

    public void initForAppCode(String appCode) {
        if (CollectionUtils.isEmpty(this.photoWallRegisters)) {
            return;
        }
        long distinctCount = this.photoWallRegisters.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.code())).distinct().count();
        Validate.isTrue((distinctCount == (long)this.photoWallRegisters.size() ? 1 : 0) != 0, (String)"\u5728\u7cfb\u7edf\u542f\u52a8\u65f6\uff0c\u68c0\u6d4b\u5230\u81f3\u5c11\u6709\u4e00\u79cd\u5df2\u6ce8\u518c\u7684\u7167\u7247\u5899\u7c7b\u578b\u5b58\u5728code\u91cd\u590d\u6216\u8005\u9519\u8bef\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        for (PhotoWallRegister<? extends PhotoWallRegisterForm> photoWallRegister : this.photoWallRegisters) {
            Class formClass = photoWallRegister.formClass();
            Validate.notNull((Object)formClass, (String)"\u5728\u7cfb\u7edf\u542f\u52a8\u65f6\uff0c\u68c0\u6d4b\u5230\u81f3\u5c11\u6709\u4e00\u79cd\u5df2\u6ce8\u518c\u7684\u7167\u7247\u5899\u7c7b\u578b\u5176formClass\u65b9\u6cd5\u8fd4\u56denull\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        }
        for (PhotoWallRegister<? extends PhotoWallRegisterForm> photoWallRegister : this.photoWallRegisters) {
            String code = photoWallRegister.code();
            String name = photoWallRegister.name();
            Class formClass = photoWallRegister.formClass();
            PhotoWallDocumentStructureVo photoWallDocumentStructure = PhotoWallRegisterValidateInit.analysis(code, name, formClass);
            try {
                this.photoWallRegisterService.saveIndex(photoWallDocumentStructure);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                LOGGER.error("code\u540d\u4e3a\uff1a{}\uff0cname\u540d\u4e3a\uff1a{} \u7684\u7167\u7247\u5899\u6ce8\u518c\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u6587\u6863\u7ed3\u6784\u5206\u6790\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a{}\uff0c\u8bf7\u68c0\u67e5!", new Object[]{code, name, e.getMessage()});
            }
        }
    }

    public boolean doInitForAppCode(String appCode) {
        return StringUtils.equals((CharSequence)appCode, (CharSequence)"default");
    }

    public static PhotoWallDocumentStructureVo analysis(String code, String name, Class<? extends PhotoWallRegisterForm> formClass) {
        if (formClass == null) {
            return null;
        }
        ArrayList fields = Lists.newArrayList();
        PhotoWallRegisterValidateInit.buildSuperForm(formClass, fields);
        PhotoWallDocumentStructureVo formVo = new PhotoWallDocumentStructureVo();
        formVo.setCode(code);
        formVo.setName(name);
        formVo.setPhotoWallDocumentStructureFields((List)fields);
        return formVo;
    }

    private static void buildSuperForm(Class<?> formClass, List<PhotoWallDocumentStructureFieldVo> formFields) {
        Class<?> superClass = formClass.getSuperclass();
        if (superClass != null) {
            PhotoWallRegisterValidateInit.buildSuperForm(superClass, formFields);
        }
        Field[] declaredFields = formClass.getDeclaredFields();
        List<Object> currentFields = Lists.newArrayList();
        if (declaredFields != null && declaredFields.length > 0) {
            currentFields = PhotoWallRegisterValidateInit.buildFields(declaredFields);
        }
        formFields.addAll(currentFields);
    }

    private static List<PhotoWallDocumentStructureFieldVo> buildFields(Field[] declaredFields) {
        ArrayList dynamicFields = Lists.newArrayList();
        for (Field declaredField : declaredFields) {
            PhotoWallField fieldAnnotation = declaredField.getAnnotation(PhotoWallField.class);
            if (fieldAnnotation == null) continue;
            String fieldName = fieldAnnotation.fieldName();
            boolean analyzer = fieldAnnotation.analyzer();
            EsFieldType esFieldType = fieldAnnotation.esFieldType();
            Validate.notBlank((CharSequence)fieldName, (String)"\u5728\u7cfb\u7edf\u542f\u52a8\u65f6\uff0c\u68c0\u6d4b\u5230\u81f3\u5c11\u6709\u4e00\u79cd\u5df2\u6ce8\u518c\u7684\u7167\u7247\u5899\u5b57\u6bb5\u8bbe\u5b9a\u7684\u4e2d\u6587\u540d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.notNull((Object)esFieldType, (String)"\u5728\u7cfb\u7edf\u542f\u52a8\u65f6\uff0c\u68c0\u6d4b\u5230\u81f3\u5c11\u6709\u4e00\u79cd\u5df2\u6ce8\u518c\u7684\u7167\u7247\u5899\u5b57\u6bb5\u8bbe\u5b9a\u7684\u7c7b\u578b\u4e3anull\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            String fieldCode = declaredField.getName();
            Class valueClass = null;
            try {
                Type genericType = declaredField.getGenericType();
                valueClass = (Class)genericType;
                Validate.isTrue((!valueClass.isPrimitive() ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u662f8\u5927\u57fa\u7840\u7c7b\u578b(int\u3001boolean\u7b49\u7b49)", (Object[])new Object[0]);
                Validate.isTrue((!valueClass.isArray() ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u662f\u6570\u7ec4", (Object[])new Object[0]);
                Validate.isTrue((!valueClass.isEnum() ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u662f\u679a\u4e3e", (Object[])new Object[0]);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("\u76ee\u524d\u7167\u7247\u5899\u7279\u5b9a\u7c7b\u578b\u4e0b\u7684\u63cf\u8ff0\u8868\u5355\uff0c\u53ea\u652f\u6301\u57fa\u672c\u7c7b\uff0c\u8bf7\u68c0\u67e5!", e);
            }
            PhotoWallDocumentStructureFieldVo fieldVo = new PhotoWallDocumentStructureFieldVo();
            fieldVo.setAnalyzer(analyzer);
            fieldVo.setEsFieldType(esFieldType.getMappedName());
            fieldVo.setFieldClass(valueClass.getName());
            fieldVo.setFieldCode(fieldCode);
            fieldVo.setFieldName(fieldName);
            dynamicFields.add(fieldVo);
        }
        return dynamicFields;
    }
}

