/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.client.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.venus.client.local.feign.FileHandleServiceFeign;
import com.bizunited.nebula.venus.client.local.service.internal.AbstractJsonAnalysis;
import com.bizunited.nebula.venus.sdk.dto.Base64UploadDto;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Primary
@Component(value="fileHandleServiceRemote")
public class FileHandleServiceRemoteImpl
extends AbstractJsonAnalysis
implements FileHandleService {
    @Autowired
    private FileHandleServiceFeign fileHandleServiceFeign;

    public OrdinaryFileVo fileUpload(String subsystem, String creator, Integer effective, String fileName, byte[] contents, String special) {
        Validate.notBlank((CharSequence)subsystem, (String)"\u5b50\u7cfb\u7edfsubsystem\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)creator, (String)"\u521b\u5efa\u8005creator\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileName, (String)"\u539f\u59cb\u6587\u4ef6\u540dfileName\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.isTrue((contents != null && contents.length > 0 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5185\u5bb9\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String base64Content = Base64Utils.encodeToString((byte[])contents);
        Base64UploadDto base64UploadDto = new Base64UploadDto();
        base64UploadDto.setBase64Contents(new String[]{base64Content});
        base64UploadDto.setFileNanmes(new String[]{fileName});
        base64UploadDto.setCreator(creator);
        base64UploadDto.setEffective(effective);
        ResponseModel responseModel = this.fileHandleServiceFeign.fileUpload(subsystem, base64UploadDto, special);
        Boolean success = responseModel.getSuccess();
        if (success == null || !success.booleanValue()) {
            throw new IllegalArgumentException(responseModel.getErrorMsg());
        }
        Object data = responseModel.getData();
        if (data == null || StringUtils.isBlank((CharSequence)data.toString())) {
            return null;
        }
        JSON jsonData = (JSON)JSON.toJSON((Object)data);
        return (OrdinaryFileVo)Lists.newArrayList(this.analysisDatas(jsonData, Lists.newArrayList(), OrdinaryFileVo.class)).get(0);
    }

    public OrdinaryFileVo fileUpload(String subsystem, String creator, Integer effective, String fileRename, String fileName, byte[] contents, String special) {
        Validate.notBlank((CharSequence)subsystem, (String)"\u5b50\u7cfb\u7edfsubsystem\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)creator, (String)"\u521b\u5efa\u8005creator\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileName, (String)"\u91cd\u547d\u540d\u540e\u7684\u6587\u4ef6\u540dfileRename\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileName, (String)"\u539f\u59cb\u6587\u4ef6\u540dfileName\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.isTrue((contents != null && contents.length > 0 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5185\u5bb9\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String base64Content = Base64Utils.encodeToString((byte[])contents);
        Base64UploadDto base64UploadDto = new Base64UploadDto();
        base64UploadDto.setBase64Contents(new String[]{base64Content});
        base64UploadDto.setFileNanmes(new String[]{fileName});
        base64UploadDto.setCreator(creator);
        base64UploadDto.setEffective(effective);
        ResponseModel responseModel = this.fileHandleServiceFeign.fileUpload(subsystem, base64UploadDto, special);
        Boolean success = responseModel.getSuccess();
        if (success == null || !success.booleanValue()) {
            throw new IllegalArgumentException(responseModel.getErrorMsg());
        }
        Object data = responseModel.getData();
        if (data == null || StringUtils.isBlank((CharSequence)data.toString())) {
            return null;
        }
        JSON jsonData = (JSON)JSON.toJSON((Object)data);
        return (OrdinaryFileVo)Lists.newArrayList(this.analysisDatas(jsonData, Lists.newArrayList(), OrdinaryFileVo.class)).get(0);
    }

    public List<OrdinaryFileVo> fileUpload(String subsystem, Base64UploadDto base64UploadDto, String special) {
        Validate.notBlank((CharSequence)subsystem, (String)"\u5b50\u7cfb\u7edfsubsystem\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)base64UploadDto.getCreator(), (String)"\u521b\u5efa\u8005creator\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        ResponseModel responseModel = this.fileHandleServiceFeign.fileUpload(subsystem, base64UploadDto, special);
        Object data = responseModel.getData();
        Boolean success = responseModel.getSuccess();
        if (success == null || !success.booleanValue()) {
            throw new IllegalArgumentException(responseModel.getErrorMsg());
        }
        if (data == null || StringUtils.isBlank((CharSequence)data.toString())) {
            return null;
        }
        JSON jsonData = (JSON)JSON.toJSON((Object)data);
        return Lists.newArrayList(this.analysisDatas(jsonData, Lists.newArrayList(), OrdinaryFileVo.class));
    }

    public OrdinaryFileVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ResponseModel responseModel = this.fileHandleServiceFeign.findById(id);
        Boolean success = responseModel.getSuccess();
        if (success == null || !success.booleanValue()) {
            throw new IllegalArgumentException(responseModel.getErrorMsg());
        }
        Object data = responseModel.getData();
        if (data == null || StringUtils.isBlank((CharSequence)data.toString())) {
            return null;
        }
        JSONObject jsonData = (JSONObject)JSON.toJSON((Object)data);
        return this.analysisData((JSON)jsonData, OrdinaryFileVo.class);
    }

    public List<OrdinaryFileVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        ResponseModel responseModel = this.fileHandleServiceFeign.findByIds(ids);
        Boolean success = responseModel.getSuccess();
        if (success == null || !success.booleanValue()) {
            throw new IllegalArgumentException(responseModel.getErrorMsg());
        }
        Object data = responseModel.getData();
        if (data == null || StringUtils.isBlank((CharSequence)data.toString())) {
            return Lists.newArrayList();
        }
        JSON jsonData = (JSON)JSON.toJSON((Object)data);
        return Lists.newArrayList(this.analysisDatas(jsonData, Lists.newArrayList(), OrdinaryFileVo.class));
    }

    public byte[] findContentByFilePathAndFileRename(String relativePath, String fileRename) {
        return this.fileHandleServiceFeign.findContentByFilePathAndFileRename(relativePath, fileRename);
    }

    public void updateByEffective(String[] fileReNames) {
        ResponseModel responseModel = this.fileHandleServiceFeign.updateByEffective(fileReNames);
        if (!responseModel.getSuccess().booleanValue()) {
            throw new IllegalArgumentException(responseModel.getErrorMsg());
        }
    }

    public void deleteFile(String relativePath, String fileName) {
        ResponseModel responseModel = this.fileHandleServiceFeign.deleteFile(relativePath, fileName);
        if (!responseModel.getSuccess().booleanValue()) {
            throw new IllegalArgumentException(responseModel.getErrorMsg());
        }
    }

    public File findFileByFilePathAndFileRename(String s, String s1) {
        throw new UnsupportedOperationException("\u8fdc\u7a0b\u8c03\u7528FileHandleService\u4e0d\u652f\u6301findFileByFilePathAndFileRename\u65b9\u6cd5\uff0c\u8bf7\u6539\u7528\u672c\u5730\u5b9e\u73b0");
    }

    public List<OrdinaryFileVo> fileUpload(String subsystem, String creator, Integer effective, MultipartFile[] files, String special) {
        throw new UnsupportedOperationException("\u8fdc\u7a0b\u8c03\u7528FileHandleService\u4e0d\u652f\u6301fileUpload\u65b9\u6cd5\uff0c\u8bf7\u6539\u7528\u672c\u5730\u5b9e\u73b0");
    }

    public List<OrdinaryFileVo> findByEffectiveDate(Date currentDate) {
        throw new UnsupportedOperationException("\u8fdc\u7a0b\u8c03\u7528FileHandleService\u4e0d\u652f\u6301findByEffectiveDate\u65b9\u6cd5\uff0c\u8bf7\u6539\u7528\u672c\u5730\u5b9e\u73b0");
    }

    public OrdinaryFileVo findByFileNameAndRelativeLocal(String fileName, String relativeLocal) {
        throw new UnsupportedOperationException("\u8fdc\u7a0b\u8c03\u7528FileHandleService\u4e0d\u652f\u6301findByFileNameAndRelativeLocal\u65b9\u6cd5\uff0c\u8bf7\u6539\u7528\u672c\u5730\u5b9e\u73b0");
    }

    public void deleteFiles(String[] fileIds) {
        throw new UnsupportedOperationException("\u8fdc\u7a0b\u8c03\u7528FileHandleService\u4e0d\u652f\u6301deleteFiles\u65b9\u6cd5\uff0c\u8bf7\u6539\u7528\u672c\u5730\u5b9e\u73b0");
    }
}

