/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.client.local.service.internal;

import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.venus.client.local.feign.PhotoWallRegisterServiceFeign;
import com.bizunited.nebula.venus.sdk.service.PhotoWallRegisterService;
import com.bizunited.nebula.venus.sdk.vo.PhotoWallDocumentStructureVo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Primary
@Component(value="photoWallRegisterServiceRemote")
public class PhotoWallRegisterServiceRemoteImpl
implements PhotoWallRegisterService {
    @Autowired
    private PhotoWallRegisterServiceFeign photoWallRegisterServiceFeign;
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotoWallRegisterServiceRemoteImpl.class);

    public void saveIndex(PhotoWallDocumentStructureVo photoWallDocumentStructure) {
        Validate.notNull((Object)photoWallDocumentStructure, (String)"\u7167\u7247\u5899\u7c7b\u578b\u7ed3\u6784\u4e0d\u80fd\u4e3anull\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String code = photoWallDocumentStructure.getCode();
        String name = photoWallDocumentStructure.getName();
        Validate.notBlank((CharSequence)code, (String)"\u7167\u7247\u5899\u7c7b\u578bcode\uff08\u7f16\u53f7\uff09\uff0c\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)name, (String)"\u7167\u7247\u5899\u7c7b\u578bname\uff08\u540d\u79f0\uff09\uff0c\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List photoWallDocumentStructureFields = photoWallDocumentStructure.getPhotoWallDocumentStructureFields();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)photoWallDocumentStructureFields) ? 1 : 0) != 0, (String)"\u7167\u7247\u5899\u7c7b\u578b\u5bf9\u5e94\u7684\u8868\u5355\u5b57\u6bb5\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        try {
            ResponseModel responseModel = this.photoWallRegisterServiceFeign.saveIndex(photoWallDocumentStructure);
            Boolean success = responseModel.getSuccess();
            if (success == null || !success.booleanValue()) {
                throw new IllegalArgumentException(responseModel.getErrorMsg());
            }
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public List<PhotoWallDocumentStructureVo> findAll() {
        throw new UnsupportedOperationException("PhotoWallRegisterService.findAll\u65b9\u6cd5\u4e0d\u652f\u6301\u8fdc\u7a0b\u8c03\u7528");
    }

    public PhotoWallDocumentStructureVo findDetailsByCode(String code) {
        throw new UnsupportedOperationException("PhotoWallRegisterService.findDetailsByCode\u65b9\u6cd5\u4e0d\u652f\u6301\u8fdc\u7a0b\u8c03\u7528");
    }
}

