/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.venus.sdk.dto.ChunkFileInitDto;
import com.bizunited.nebula.venus.sdk.dto.ChunkFileMergeDto;
import com.bizunited.nebula.venus.sdk.dto.ChunkFileUploadDto;
import com.bizunited.nebula.venus.sdk.dto.ChunkFileUploadQueryDto;
import com.bizunited.nebula.venus.sdk.service.file.ChunkFileService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/venus/chunkFile"})
public class ChunkFileController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkFileController.class);
    @Autowired
    private ChunkFileService chunkFileService;

    @ApiOperation(value="\u5206\u5757\u6587\u4ef6\u521d\u59cb\u5316(\u5206\u5757\u6587\u4ef6\u4e0a\u4f20\u7b2c\u4e00\u6b65,\u7cfb\u7edf\u751f\u6210\u4e00\u4e2a\u6587\u4ef6\u4e0a\u4f20\u4e3b\u4f53\u8bb0\u5f55\u4fe1\u606f)")
    @RequestMapping(path={"/initChunk"}, method={RequestMethod.POST})
    public ResponseModel initChunk(@RequestBody ChunkFileInitDto dto) {
        try {
            return this.buildHttpResult(this.chunkFileService.initChunk(dto));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u5757\u6587\u4ef6\u4e0a\u4f20(\u5206\u5757\u6587\u4ef6\u4e0a\u4f20\u7b2c\u4e8c\u6b65,\u5c06\u5206\u5757\u6263\u7684\u5b50\u6587\u4ef6\u4e0a\u4f20\u7cfb\u7edf)")
    @RequestMapping(path={"/uploadChunk"}, method={RequestMethod.POST})
    public ResponseModel uploadChunk(@RequestParam(name="file") MultipartFile file, @ApiParam(name="ChunkFileUploadDto") ChunkFileUploadDto dto) {
        try {
            this.chunkFileService.uploadChunk(file, dto);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u5757\u6587\u4ef6\u5408\u5e76\u5206\u5757,\u5e76\u4e0a\u4f20\u6587\u4ef6\u7cfb\u7edf(\u5206\u5757\u6587\u4ef6\u4e0a\u4f20\u7b2c\u4e09\u6b65,\u5c06\u8be5\u5206\u5757\u4e3b\u4f53\u4e0b\u7684\u6240\u6709\u5206\u5757\u6587\u4ef6\u8fdb\u884c\u5408\u5e76\u751f\u6210\u5b8c\u6574\u7684\u6587\u4ef6\u4fe1\u606f,\u5e76\u4e0a\u4f20\u6587\u4ef6\u7cfb\u7edf)")
    @RequestMapping(path={"/mergeChunk"}, method={RequestMethod.POST})
    public ResponseModel mergeChunk(@RequestBody ChunkFileMergeDto dto) {
        try {
            return this.buildHttpResult(this.chunkFileService.mergeChunk(dto));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u5757\u6587\u4ef6\u4e0a\u4f20\u67e5\u8be2,\u7528\u4e8e\u67e5\u8be2\u6307\u5b9a\u6587\u4ef6\u5206\u5757\u4e3b\u4f53\u5df2\u4e0a\u4f20\u7684\u5206\u5757\u6570\u4fe1\u606f(\u53ef\u7528\u4e8e\u65ad\u70b9\u7eed\u4f20)")
    @RequestMapping(path={"/uploadChunkQuery"}, method={RequestMethod.POST})
    public ResponseModel uploadChunkQuery(@RequestBody ChunkFileUploadQueryDto dto) {
        try {
            return this.buildHttpResult(this.chunkFileService.uploadChunkQuery(dto));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

