/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.service.internal;

import com.bizunited.nebula.venus.service.local.service.images.ImageHandler;
import com.bizunited.nebula.venus.service.local.service.images.ImageHandlerBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractImageHandleService {
    private static final Log LOGGER = LogFactory.getLog(AbstractImageHandleService.class);
    private static final String MESS_CUT_IMAGE = "cutimage";
    private static final String MESS_ZOOM_IMAGE = "zoomimage";
    private static final String MESS_MAKE_IMAGE = "markimage";

    protected byte[] fileContentsQuery(byte[] fileBytes, String special, String prefix) throws IOException {
        String[] specialSteps = special.split("\\-\\>");
        if (specialSteps.length == 0) {
            return fileBytes;
        }
        BufferedImage bufferedImage = null;
        try {
            String[] stringArray = null;
            try (ByteArrayInputStream in = new ByteArrayInputStream(fileBytes);){
                bufferedImage = ImageIO.read(in);
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        if (bufferedImage == null) {
            return fileBytes;
        }
        ImageHandlerBuilder.Builder builder = new ImageHandlerBuilder.Builder();
        for (String specialStep : specialSteps) {
            String[] params = specialStep.split("\\|");
            if (StringUtils.equals((CharSequence)params[0], (CharSequence)MESS_CUT_IMAGE)) {
                this.builderCutAndZoomImageHandle(params, builder, MESS_CUT_IMAGE);
                continue;
            }
            if (StringUtils.equals((CharSequence)params[0], (CharSequence)MESS_ZOOM_IMAGE)) {
                this.builderCutAndZoomImageHandle(params, builder, MESS_ZOOM_IMAGE);
                continue;
            }
            if (!StringUtils.equals((CharSequence)params[0], (CharSequence)MESS_MAKE_IMAGE)) continue;
            this.builderMarkImageHandle(params, builder);
        }
        ImageHandler imageHandle = builder.build();
        BufferedImage imageResults = imageHandle.dispose(bufferedImage);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)imageResults, prefix, out);
        return out.toByteArray();
    }

    protected void builderMarkImageHandle(String[] params, ImageHandlerBuilder.Builder builder) {
        String markValue = null;
        Integer fontSize = 30;
        for (String param : params) {
            String[] paramVars = param.split("=");
            if (StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"markValue")) {
                markValue = paramVars[1];
            }
            if (!StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"fontSize")) continue;
            fontSize = Integer.parseInt(paramVars[1]);
        }
        if (StringUtils.isEmpty(markValue)) {
            throw new IllegalArgumentException("markValue must be set value!");
        }
        builder.createMarkHandler(markValue, fontSize);
    }

    protected void builderCutAndZoomImageHandle(String[] params, ImageHandlerBuilder.Builder builder, String opType) {
        Integer width = null;
        Integer height = null;
        Float ratio = null;
        for (String param : params) {
            String[] paramVars = param.split("=");
            if (StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"width")) {
                width = Integer.parseInt(paramVars[1]);
                continue;
            }
            if (StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"height")) {
                height = Integer.parseInt(paramVars[1]);
                continue;
            }
            if (!StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"ratio")) continue;
            ratio = Float.valueOf(Float.parseFloat(paramVars[1]));
        }
        if (ratio != null && (ratio.floatValue() <= 0.0f || ratio.floatValue() >= 1.0f)) {
            throw new IllegalArgumentException("ratio must between from 0 to 1!");
        }
        if (ratio == null && (width == null || height == null)) {
            throw new IllegalArgumentException("width and height must be set value!");
        }
        if (ratio != null && StringUtils.equals((CharSequence)opType, (CharSequence)MESS_CUT_IMAGE)) {
            builder.createCutHandler(ratio.floatValue());
        } else if (ratio != null && StringUtils.equals((CharSequence)opType, (CharSequence)MESS_ZOOM_IMAGE)) {
            builder.createZoomHandler(ratio.floatValue());
        } else if (ratio == null && StringUtils.equals((CharSequence)opType, (CharSequence)MESS_CUT_IMAGE)) {
            builder.createCutHandler(width, height);
        } else if (ratio == null && StringUtils.equals((CharSequence)opType, (CharSequence)MESS_ZOOM_IMAGE)) {
            builder.createZoomHandler(width, height);
        }
    }
}

