/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.service.internal;

import com.bizunited.nebula.common.util.NebulaToolkitUtil;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.dto.ChunkFileInitDto;
import com.bizunited.nebula.venus.sdk.dto.ChunkFileMergeDto;
import com.bizunited.nebula.venus.sdk.dto.ChunkFileUploadDto;
import com.bizunited.nebula.venus.sdk.dto.ChunkFileUploadQueryDto;
import com.bizunited.nebula.venus.sdk.event.VenusFileEventListener;
import com.bizunited.nebula.venus.sdk.service.file.ChunkFileService;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.service.file.FileRelativeTemplate;
import com.bizunited.nebula.venus.sdk.vo.ChunkFileInitVo;
import com.bizunited.nebula.venus.sdk.vo.ChunkFileUploadVo;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.bizunited.nebula.venus.service.local.entity.ChunkFileEntity;
import com.bizunited.nebula.venus.service.local.entity.ChunkFileItemEntity;
import com.bizunited.nebula.venus.service.local.repository.ChunkFileItemRepository;
import com.bizunited.nebula.venus.service.local.repository.ChunkFileRepository;
import com.bizunited.nebula.venus.service.local.service.helper.FileServiceHelper;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public class ChunkFileServiceImpl
implements ChunkFileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkFileServiceImpl.class);
    @Autowired(required=false)
    private ChunkFileRepository chunkFileRepository;
    @Autowired(required=false)
    private ChunkFileItemRepository chunkFileItemRepository;
    @Autowired(required=false)
    private VenusFileEventListener venusFileEventListener;
    @Autowired(required=false)
    private FileServiceHelper fileServiceHelper;
    @Autowired(required=false)
    private FileRelativeTemplate fileRelativeTemplate;
    @Autowired(required=false)
    private FileHandleService fileHandleService;

    @Transactional
    public ChunkFileInitVo initChunk(ChunkFileInitDto dto) {
        Validate.notBlank((CharSequence)dto.getOriginalFileName(), (String)"\u7f3a\u5931\u6587\u4ef6\u540d", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPrefix(), (String)"\u7f3a\u5931\u6587\u4ef6\u540e\u7f00", (Object[])new Object[0]);
        Validate.isTrue((Objects.nonNull(dto.getTotalChunks()) && dto.getTotalChunks() > 0 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5206\u5757\u6570\u9519\u8bef", (Object[])new Object[0]);
        ChunkFileEntity chunkFileEntity = (ChunkFileEntity)((Object)NebulaToolkitUtil.copyObjectByWhiteList((Object)dto, ChunkFileEntity.class, (String[])new String[0]));
        Date nowDate = new Date();
        String currentAccount = this.fileServiceHelper.findCurrentAccount();
        chunkFileEntity.setCreateAccount(currentAccount);
        chunkFileEntity.setCreateTime(nowDate);
        chunkFileEntity.setModifyAccount(currentAccount);
        chunkFileEntity.setModifyTime(nowDate);
        chunkFileEntity.setTenantCode(TenantUtils.getTenantCode());
        this.chunkFileRepository.save((Object)chunkFileEntity);
        ChunkFileInitVo chunkFileInitVo = new ChunkFileInitVo();
        chunkFileInitVo.setChunkFileId(chunkFileEntity.getId());
        return chunkFileInitVo;
    }

    @Transactional
    public void uploadChunk(MultipartFile file, ChunkFileUploadDto dto) {
        Validate.notBlank((CharSequence)dto.getChunkFileId(), (String)"\u7f3a\u5931\u5206\u5757\u6587\u4ef6\u4e3b\u4f53ID", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getChunkNumber(), (String)"\u7f3a\u5931\u6587\u4ef6\u5206\u5757\u6570", (Object[])new Object[0]);
        ChunkFileEntity chunkFileEntity = this.chunkFileRepository.findById(dto.getChunkFileId()).orElse(null);
        Validate.notNull((Object)((Object)chunkFileEntity), (String)"\u6587\u4ef6\u5206\u5757\u4e3b\u4f53\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ChunkFileItemEntity fileItemEntity = this.chunkFileItemRepository.findByChunkFileIdAndAndChunkNumber(dto.getChunkFileId(), dto.getChunkNumber());
        if (Objects.nonNull((Object)fileItemEntity)) {
            LOGGER.info("\u6587\u4ef6\u4e3b\u4f53:{},\u5206\u5757\u6570:{},\u5df2\u7ecf\u4e0a\u4f20,\u8df3\u8fc7\u6267\u884c", (Object)dto.getChunkFileId(), (Object)dto.getChunkNumber());
            return;
        }
        String originalFilename = null;
        String fileRename = null;
        String relativePath = null;
        try {
            byte[] fileContext = file.getBytes();
            originalFilename = file.getOriginalFilename();
            fileRename = StringUtils.join((Object[])new String[]{UUID.randomUUID().toString(), ".", "part"});
            relativePath = this.fileRelativeTemplate.generatRelativePath("chunck", originalFilename);
            this.venusFileEventListener.onSaveFile(relativePath, originalFilename, fileRename, fileContext);
        }
        catch (Exception e) {
            LOGGER.error("\u5206\u5757\u6587\u4ef6\u4e0a\u4f20\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u5206\u5757\u6587\u4ef6\u4e0a\u4f20\u9519\u8bef");
        }
        Date nowDate = new Date();
        String currentAccount = this.fileServiceHelper.findCurrentAccount();
        ChunkFileItemEntity chunkFileItemEntity = new ChunkFileItemEntity();
        chunkFileItemEntity.setChunkNumber(dto.getChunkNumber());
        chunkFileItemEntity.setCreateAccount(currentAccount);
        chunkFileItemEntity.setCreateTime(nowDate);
        chunkFileItemEntity.setChunkFileName(fileRename);
        chunkFileItemEntity.setModifyAccount(currentAccount);
        chunkFileItemEntity.setModifyTime(nowDate);
        chunkFileItemEntity.setChunkOriginalFileName(originalFilename);
        chunkFileItemEntity.setRelativeLocal(relativePath);
        chunkFileItemEntity.setTenantCode(TenantUtils.getTenantCode());
        chunkFileItemEntity.setChunkFileId(chunkFileEntity.getId());
        this.chunkFileItemRepository.save((Object)chunkFileItemEntity);
    }

    /*
     * Exception decompiling
     */
    @Transactional
    public OrdinaryFileVo mergeChunk(ChunkFileMergeDto dto) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ChunkFileUploadVo uploadChunkQuery(ChunkFileUploadQueryDto dto) {
        Validate.notBlank((CharSequence)dto.getChunkFileId(), (String)"\u7f3a\u5931\u5206\u5757\u6587\u4ef6\u4e3b\u4f53ID", (Object[])new Object[0]);
        ChunkFileEntity chunkFileEntity = this.chunkFileRepository.findById(dto.getChunkFileId()).orElse(null);
        Validate.notNull((Object)((Object)chunkFileEntity), (String)"\u6587\u4ef6\u5206\u5757\u4e3b\u4f53\u8bb0\u5f55\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List chunkFileItemEntities = this.chunkFileItemRepository.findByChunkFileId(dto.getChunkFileId());
        chunkFileItemEntities = (List)ObjectUtils.defaultIfNull(chunkFileItemEntities, (Object)Lists.newArrayList());
        List chunkNumbers = chunkFileItemEntities.stream().map(ChunkFileItemEntity::getChunkNumber).collect(Collectors.toList());
        ChunkFileUploadVo chunkFileUploadVo = new ChunkFileUploadVo();
        chunkFileUploadVo.setChunkNumbers(chunkNumbers);
        chunkFileUploadVo.setChunkFileId(dto.getChunkFileId());
        return chunkFileUploadVo;
    }

    private /* synthetic */ void lambda$mergeChunk$0(ChunkFileItemEntity chunkFileItemEntity) {
        this.venusFileEventListener.onDeleteFile(chunkFileItemEntity.getRelativeLocal(), chunkFileItemEntity.getChunkOriginalFileName(), chunkFileItemEntity.getChunkFileName());
    }
}

