/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.service.internal;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.async.AsyncTaskRunnable;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.config.SimpleVenusProperties;
import com.bizunited.nebula.venus.sdk.dto.Base64UploadDto;
import com.bizunited.nebula.venus.sdk.event.VenusFileEventListener;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.service.file.FileRelativeTemplate;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.bizunited.nebula.venus.service.local.entity.OrdinaryFileEntity;
import com.bizunited.nebula.venus.service.local.repository.OrdinaryFileRepository;
import com.bizunited.nebula.venus.service.local.service.async.FileAsyncHandler;
import com.bizunited.nebula.venus.service.local.service.internal.AbstractImageHandleService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class FileHandleServiceImpl
extends AbstractImageHandleService
implements FileHandleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileHandleServiceImpl.class);
    @Autowired
    private SimpleVenusProperties venusProperties;
    @Autowired
    private OrdinaryFileRepository ordinaryFileRepository;
    @Autowired
    private FileRelativeTemplate fileRelativeTemplate;
    @Autowired
    private VenusFileEventListener venusFileEventListener;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ApplicationContext applicationContext;
    private static Cache<String, byte[]> cacheMapping = CacheBuilder.newBuilder().initialCapacity(100000).expireAfterWrite(20L, TimeUnit.MINUTES).maximumSize(1000000L).build();

    @Transactional
    public List<OrdinaryFileVo> fileUpload(String subSystem, Base64UploadDto base64UploadDto, String special) {
        Integer effective = base64UploadDto.getEffective();
        String creator = base64UploadDto.getCreator();
        String[] fileNanmes = base64UploadDto.getFileNanmes();
        String[] base64Contents = base64UploadDto.getBase64Contents();
        Validate.notBlank((CharSequence)creator, (String)"\u6587\u4ef6\u7684\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (base64Contents == null || base64Contents.length == 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684base64\u7f16\u7801\u6587\u4ef6\u5185\u5bb9!!");
        }
        if (fileNanmes == null || fileNanmes.length == 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u6587\u4ef6\u540d\u6570\u91cf\u4fe1\u606f!!");
        }
        Validate.isTrue((fileNanmes.length == base64Contents.length ? 1 : 0) != 0, (String)"\u6587\u4ef6\u5185\u5bb9\u6570\u91cf\u548c\u6587\u4ef6\u540d\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedList<OrdinaryFileVo> ordinaryFileVos = new LinkedList<OrdinaryFileVo>();
        for (int index = 0; index < fileNanmes.length; ++index) {
            String originalFilename = fileNanmes[index];
            this.validatePrefix(originalFilename);
            String base64Content = base64Contents[index];
            byte[] fileContext = Base64Utils.decodeFromString((String)base64Content);
            OrdinaryFileVo result = this.fileUpload(subSystem, creator, effective, originalFilename, fileContext, special);
            ordinaryFileVos.add(result);
        }
        return ordinaryFileVos;
    }

    @Transactional
    public List<OrdinaryFileVo> fileUpload(String subSystem, String creator, Integer effective, MultipartFile[] files, String special) {
        Validate.notNull((Object)(files != null && files.length > 0 ? 1 : 0), (String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4fe1\u606f\u81f3\u5c11\u6709\u4e00\u4e2a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)creator, (String)"\u9644\u4ef6\u7684\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LinkedList<OrdinaryFileVo> ordinaryFileVos = new LinkedList<OrdinaryFileVo>();
        for (MultipartFile file : files) {
            byte[] fileContext = null;
            try {
                fileContext = file.getBytes();
            }
            catch (IOException | RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e);
            }
            String originalFilename = file.getOriginalFilename();
            this.validatePrefix(originalFilename);
            OrdinaryFileVo result = this.fileUpload(subSystem, creator, effective, originalFilename, fileContext, special);
            ordinaryFileVos.add(result);
        }
        return ordinaryFileVos;
    }

    @Transactional
    public OrdinaryFileVo fileUpload(String subsystem, String creator, Integer effective, String fileName, byte[] contents, String special) {
        return this.fileUpload(subsystem, creator, effective, null, fileName, contents, special);
    }

    @Transactional
    public OrdinaryFileVo fileUpload(String subSystem, String creator, Integer effective, String fileRename, String fileName, byte[] contents, String special) {
        Validate.notBlank((CharSequence)creator, (String)"\u6587\u4ef6\u7684\u63d0\u4ea4\u4eba\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (contents == null || contents.length == 0) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684base64\u7f16\u7801\u6587\u4ef6\u5185\u5bb9!!");
        }
        Validate.notBlank((CharSequence)fileName, (String)"\u9519\u8bef\u7684\u6587\u4ef6\u540d\u6570\u91cf\u4fe1\u606f!!", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)subSystem)) {
            subSystem = "default";
        }
        this.validatePrefix(fileName);
        int prefixIndex = fileName.lastIndexOf(46);
        String prefix = null;
        if (prefixIndex != -1) {
            prefix = fileName.substring(prefixIndex + 1);
            prefix = prefix.toLowerCase();
        }
        if (StringUtils.isBlank((CharSequence)fileRename)) {
            String renameImage = UUID.randomUUID().toString();
            fileRename = StringUtils.join((Object[])new String[]{renameImage, ".", prefix});
        }
        String relativePath = this.fileRelativeTemplate.generatRelativePath(subSystem, fileName);
        OrdinaryFileEntity result = this.fileUpload(relativePath, fileName, fileRename, prefix, effective, creator, contents, special);
        OrdinaryFileVo resultVo = (OrdinaryFileVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)result, OrdinaryFileVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return resultVo;
    }

    private void validatePrefix(String originalFilename) {
        int prefixIndex = originalFilename.lastIndexOf(46);
        Validate.isTrue((prefixIndex != -1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u4e0a\u4f20\u7684\u6587\u4ef6\uff08%s\uff09\u5fc5\u987b\u643a\u5e26\u6587\u4ef6\u540e\u7f00\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{originalFilename});
        String prefix = originalFilename.substring(prefixIndex + 1);
        prefix = prefix.toLowerCase();
        if (!(!StringUtils.isBlank((CharSequence)prefix) && (StringUtils.equals((CharSequence)prefix, (CharSequence)"png") || StringUtils.equals((CharSequence)prefix, (CharSequence)"gif") || StringUtils.equals((CharSequence)prefix, (CharSequence)"jpg") || StringUtils.equals((CharSequence)prefix, (CharSequence)"jpeg") || StringUtils.equals((CharSequence)prefix, (CharSequence)"bmp") || StringUtils.equalsAnyIgnoreCase((CharSequence)prefix, (CharSequence[])this.venusProperties.getWhitePrefixs())))) {
            throw new IllegalArgumentException("\u53ea\u6709\u4f4d\u56fe\u6587\u4ef6(bmp/jpg/png/gif/white prefixs)\u548c\u5728\u6269\u5c55\u540d\u767d\u540d\u5355\u8bbe\u5b9a\u4e2d\u7684\u6587\u4ef6\uff0c\u624d\u80fd\u8fdb\u884c\u4e0a\u4f20\u7ba1\u7406!");
        }
    }

    private OrdinaryFileEntity fileUpload(String relativePath, String originalFilename, String fileRename, String prefix, Integer effective, String creator, byte[] fileContext, String special) {
        String tenantCode = TenantUtils.getTenantCode();
        Date effectiveDate = null;
        Calendar calendar = Calendar.getInstance();
        if (effective != null) {
            Validate.isTrue((effective > 0 ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u6709\u6548\u671f\u65f6\u957f\uff08\u5355\u4f4d\u201c\u5929\u201d\uff09, \u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            calendar.add(5, effective);
            effectiveDate = calendar.getTime();
        } else {
            calendar.add(5, this.venusProperties.getEffective());
            effectiveDate = calendar.getTime();
        }
        long fileSize = fileContext.length;
        OrdinaryFileEntity result = new OrdinaryFileEntity();
        Date now = new Date();
        result.setCommitUser(creator);
        result.setCreateAccount(creator);
        result.setCreateTime(now);
        result.setEffectiveDate(effectiveDate);
        result.setFileName(fileRename);
        result.setModifyAccount(creator);
        result.setModifyTime(now);
        result.setOriginalFileName(originalFilename);
        result.setPrefix(prefix);
        result.setRelativeLocal(relativePath);
        result.setTenantCode(tenantCode);
        result.setFileSize(fileSize);
        this.ordinaryFileRepository.save((Object)result);
        this.ordinaryFileRepository.flush();
        if (StringUtils.isNotBlank((CharSequence)special) && StringUtils.equalsAnyIgnoreCase((CharSequence)prefix, (CharSequence[])new CharSequence[]{"jpeg", "jpg", "gif", "bmp", "png"})) {
            try {
                fileContext = super.fileContentsQuery(fileContext, special, prefix);
                result.setFileSize(Long.valueOf(fileContext.length));
            }
            catch (IOException | RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        if (!this.venusProperties.getAsync().booleanValue()) {
            this.venusFileEventListener.onSaveFile(relativePath, originalFilename, fileRename, fileContext);
        } else {
            FileAsyncHandler currentFileAsyncHandler = (FileAsyncHandler)this.applicationContext.getBean(FileAsyncHandler.class, new Object[]{tenantCode, relativePath, originalFilename, fileRename, fileContext});
            String key = StringUtils.join((Object[])new String[]{relativePath, "/", fileRename});
            cacheMapping.put((Object)key, (Object)fileContext);
            this.nebulaToolkitService.async((AsyncTaskRunnable)currentFileAsyncHandler);
        }
        return result;
    }

    public OrdinaryFileVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        OrdinaryFileEntity ordinaryFileEntity = this.ordinaryFileRepository.findById(id).orElse(null);
        if (ordinaryFileEntity == null) {
            return null;
        }
        return (OrdinaryFileVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)ordinaryFileEntity, OrdinaryFileVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<OrdinaryFileVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List ordinaryFileEntities = this.ordinaryFileRepository.findAllById(ids);
        if (CollectionUtils.isEmpty((Collection)ordinaryFileEntities)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)ordinaryFileEntities, OrdinaryFileEntity.class, OrdinaryFileVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<OrdinaryFileVo> findByEffectiveDate(Date currentDate) {
        if (currentDate == null) {
            return Collections.emptyList();
        }
        List<OrdinaryFileEntity> files = this.ordinaryFileRepository.findByEffectiveDateAndTenantCode(currentDate, TenantUtils.getTenantCode());
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(files, OrdinaryFileEntity.class, OrdinaryFileVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<OrdinaryFileVo>(collection);
    }

    public OrdinaryFileVo findByFileNameAndRelativeLocal(String fileName, String relativeLocal) {
        if (relativeLocal == null || StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        OrdinaryFileEntity ordinaryFile = this.ordinaryFileRepository.findByFileNameAndRelativeLocalAndTenantCode(fileName, relativeLocal, TenantUtils.getTenantCode());
        if (ordinaryFile == null) {
            return null;
        }
        return (OrdinaryFileVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)ordinaryFile, OrdinaryFileVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public byte[] findContentByFilePathAndFileRename(String relativePath, String fileRename) {
        String key = StringUtils.join((Object[])new String[]{relativePath, "/", fileRename});
        byte[] cacheBytes = null;
        try {
            cacheBytes = (byte[])cacheMapping.get((Object)key, (Callable)new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    return new byte[0];
                }
            });
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (cacheBytes != null && cacheBytes.length > 0) {
            return cacheBytes;
        }
        return this.venusFileEventListener.onReadFileContent(relativePath, fileRename);
    }

    @Transactional
    public void updateByEffective(String[] fileReNames) {
        if (fileReNames == null || fileReNames.length == 0) {
            return;
        }
        Date effectiveDate = null;
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, this.venusProperties.getEffective());
        effectiveDate = calendar.getTime();
        for (int index = 0; index < fileReNames.length; ++index) {
            String relativeLocal;
            String fileReNameItem = fileReNames[index];
            int targetIndex = fileReNameItem.lastIndexOf(47);
            String fileReName = fileReNameItem.substring(targetIndex + 1);
            OrdinaryFileEntity currentOrdinaryFile = this.ordinaryFileRepository.findByFileNameAndRelativeLocalAndTenantCode(fileReName, relativeLocal = fileReNameItem.substring(0, targetIndex), TenantUtils.getTenantCode());
            if (currentOrdinaryFile == null) continue;
            currentOrdinaryFile.setEffectiveDate(effectiveDate);
            currentOrdinaryFile.setTenantCode(TenantUtils.getTenantCode());
            this.ordinaryFileRepository.save((Object)currentOrdinaryFile);
        }
    }

    @Transactional
    public void deleteFiles(String[] fileIds) {
        Validate.notNull((Object)fileIds, (String)"\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u6587\u4ef6\u7684\u6570\u636e\u5e93\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((fileIds.length > 0 ? 1 : 0) != 0, (String)"\u81f3\u5c11\u4f20\u5165\u4e00\u4e2a\u6587\u4ef6\u7684\u6570\u636e\u5e93\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        for (int index = 0; index < fileIds.length; ++index) {
            String fileId = fileIds[index];
            Optional op = this.ordinaryFileRepository.findById(fileId);
            OrdinaryFileEntity currentOrdinaryFile = op.orElse(null);
            if (currentOrdinaryFile == null) continue;
            this.venusFileEventListener.onDeleteFile(currentOrdinaryFile.getRelativeLocal(), currentOrdinaryFile.getOriginalFileName(), currentOrdinaryFile.getFileName());
            this.ordinaryFileRepository.deleteById(fileId);
        }
    }

    @Transactional
    public void deleteFile(String filePath, String fileName) {
        Validate.notNull((Object)filePath, (String)"\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileName, (String)"\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrdinaryFileEntity file = this.ordinaryFileRepository.findByFileNameAndRelativeLocalAndTenantCode(fileName, StringUtils.trim((String)filePath), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)file), (String)"\u5220\u9664\u7684\u6587\u4ef6\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.venusFileEventListener.onDeleteFile(file.getRelativeLocal(), file.getOriginalFileName(), file.getFileName());
        this.ordinaryFileRepository.delete((Object)file);
    }

    public File findFileByFilePathAndFileRename(String relativePath, String fileRename) {
        String key = StringUtils.join((Object[])new String[]{relativePath, "/", fileRename});
        return this.venusFileEventListener.onGetFile(relativePath, fileRename);
    }
}

