/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.venus.service.local.service.internal;

import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.service.image.ImageHandleService;
import com.bizunited.nebula.venus.service.local.entity.OrdinaryFileEntity;
import com.bizunited.nebula.venus.service.local.repository.OrdinaryFileRepository;
import com.bizunited.nebula.venus.service.local.service.internal.AbstractImageHandleService;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ImageHandleServiceImpl
extends AbstractImageHandleService
implements ImageHandleService {
    @Autowired(required=false)
    private OrdinaryFileRepository ordinaryFileRepository;
    @Autowired(required=false)
    private FileHandleService fileHandleService;

    public byte[] imageQueryById(String id, String special) throws IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            return new byte[0];
        }
        OrdinaryFileEntity ordinaryFile = this.ordinaryFileRepository.findById(id).orElse(null);
        if (ordinaryFile == null) {
            return new byte[0];
        }
        String prefix = ordinaryFile.getPrefix();
        String originalFileName = ordinaryFile.getOriginalFileName();
        String relativeLocal = ordinaryFile.getRelativeLocal();
        String fileName = ordinaryFile.getFileName();
        return this.fileContentsQuery(relativeLocal, originalFileName, fileName, special, prefix);
    }

    public byte[] imageQuery(String relativeLocal, String fileName) throws IOException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{relativeLocal, fileName})) {
            return new byte[0];
        }
        OrdinaryFileEntity ordinaryFile = this.ordinaryFileRepository.findByFileNameAndRelativeLocalAndTenantCode(fileName, relativeLocal, TenantUtils.getTenantCode());
        if (ordinaryFile == null) {
            return new byte[0];
        }
        String prefix = ordinaryFile.getPrefix();
        String originalFileName = ordinaryFile.getOriginalFileName();
        return this.fileContentsQuery(relativeLocal, originalFileName, fileName, "", prefix);
    }

    private byte[] fileContentsQuery(String relativeLocal, String fileName, String fileRename, String special, String prefix) throws IOException {
        byte[] fileBytes = this.fileHandleService.findContentByFilePathAndFileRename(relativeLocal, fileRename);
        if (fileBytes == null) {
            return new byte[0];
        }
        if (StringUtils.isBlank((CharSequence)special) || !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"jpeg") && !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"jpg") && !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"gif") && !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"bmp") && !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"png")) {
            return fileBytes;
        }
        return super.fileContentsQuery(fileBytes, special, prefix);
    }

    public byte[] imageQuery(String folder, String imageFile, String prefix, String special) throws IOException {
        String relativePath = folder;
        String fileName = imageFile + "." + prefix;
        return this.fileContentsQuery(relativePath, fileName, fileName, special, prefix);
    }
}

