package com.bizunited.platform.core.common.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * 中文字符的验证操作工具
 * @description:
 * @author: weitongyan
 * @date: 29/Mar/2019 17:36
 */
public class ChineseCharUtil {

  private ChineseCharUtil(){}

  /**
   * 判断一个字符串是否含有中文
   * @param str
   * @return
   */
  public static boolean hasChinese(String str) {
    if (StringUtils.isBlank(str)){
      return false;
    }
    for (char c : str.toCharArray()) {
      // 有一个中文字符就返回
      if (isChinese(c)){
        return true;
      }
    }
    return false;
  }

  /**
   * 判断一个字符是否是中文
   * @param c
   * @return
   */
  private static boolean isChinese(char c) {
    return c >= 0x4E00 &&  c <= 0x9FA5;// 根据字节码判断
  }
    
}
