package com.bizunited.platform.core.configuration;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.core.service.file.NebulaFileServiceSimpleImpl;

/**
 * 表单引擎各功能中涉及到的文件介质提供者的配置
 * @author yinwenjie
 */
@Configuration
public class FileServiceConfig {
  
  @Bean
  @ConditionalOnMissingBean(NebulaFileService.class)
  public NebulaFileService getNebulaFileService() {
    return new NebulaFileServiceSimpleImpl();
  }
}