package com.bizunited.platform.core.configuration;

import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.saturn.context.SaturnContext;
import com.bizunited.platform.saturn.context.service.PersistentServiceFactory;
import com.bizunited.platform.saturn.context.service.simple.SimplePersistentServiceFactory;
import com.bizunited.platform.saturn.engine.SaturnEngine;
import com.bizunited.platform.saturn.scan.SimpleClassScanner;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;

import javax.servlet.MultipartConfigElement;

@Configuration
public class NebulaToolkitConfig {

  /**
   * 用柯伊伯基于业务工程中的哪些包完成类模型扫描，一般来说是entity和vo那个包
   */
  @Value("${nebula.scanPackages}")
  private String[] nebulaScanPackages;
  /**
   * 最大允许的单个文件上传大小（单位MB），默认为1MB
   */
  @Value("${nebula.file.maxFileSize}")
  private Integer maxFileSize = 1;

  /**
   * 这保证了在业务系统只是用了技术中台“底座”的情况下，该工具包同样能正常工作
   * @return 
   */
  @Bean("nebulaToolkitService")
  public NebulaToolkitService getNebulaToolkitService() {
    return new NebulaToolkitService();
  }

  /**
   * 初始saturn骨架扫描上下文，只不过这里只进行扫描，不用进行代码生成
   * @return
   */
  @Bean
  public SaturnContext getSaturnContext() {
    String[] rootScanPackages = nebulaScanPackages;
    PersistentServiceFactory persistentServiceFactory = new SimplePersistentServiceFactory();
    SaturnEngine.Builder builder = new SaturnEngine.Builder();
    SaturnEngine saturnEngine = builder.onlyScan(true)
        .setRootScanPackages(rootScanPackages)
        .addClassScanners(new SimpleClassScanner())
        .setPersistentServiceFactory(persistentServiceFactory)
        .build();
    // 开始执行（只执行Saturn骨架的扫描过程）
    try {
      saturnEngine.eve();
    } catch(Exception e) {
      throw new IllegalArgumentException("初始化saturn骨架配置问题，请检查!!");
    }
    return saturnEngine.getSaturnContext();
  }

  /**
   * 文件上传配置
   * */
  @Bean
  public MultipartConfigElement multipartConfigElement() {
    MultipartConfigFactory factory = new MultipartConfigFactory();
    // 单个文件最大
    factory.setMaxFileSize(DataSize.ofMegabytes(maxFileSize.longValue()));
    // 设置总上传数据总大小
    factory.setMaxRequestSize(DataSize.ofMegabytes(maxFileSize * 5l));
    return factory.createMultipartConfig();
  }

}
