package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DictItemEntity;
import com.bizunited.platform.core.service.DictItemService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * DictItemController
 *
 * @description:
 * @author: yanwe
 * @date: 14/Feb/2019 09:52
 */
@RestController
@RequestMapping("/v1/nebula/dictItems")
public class DictItemController extends BaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(DictItemController.class);
  @Autowired private DictItemService dictItemService;

  @ApiOperation(value = "根据字典编码查询所有子项")
  @RequestMapping(value = "/findByCode", method = RequestMethod.GET)
  public ResponseModel findByCode(@RequestParam(name = "dictCode") @ApiParam(name = "dictCode", value = "指定的字典编码") String dictCode) {
    try {
      return buildHttpResultW(dictItemService.findItemsByCode(dictCode), "");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "为字典类 修改/添加/删除 明细项")
  @RequestMapping(value = "/update", method = RequestMethod.POST)
  public ResponseModel update(
          @RequestParam(name = "dictCode") @ApiParam(name = "dictCode", value = "字典编码") String dictCode,
          @ApiParam(name = "字典明细信息") @RequestBody Set<DictItemEntity> items) {
    LOGGER.debug("待新增/修改的字典编码：{},字典信息：{}", dictCode, JSON.toJSONString(items));
    try {
      return buildHttpResultW(dictItemService.save(dictCode, items), "");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  /**
   * 根据字典ID启用字典
   * @param id
   * @return
   */
  @ApiOperation(value = "启用字典")
  @PutMapping("/enable")
  public ResponseModel enable(@ApiParam(name = "字典ID") @RequestParam("id") String id){
    try {
      DictItemEntity dictItem = dictItemService.enable(id);
      return buildHttpResultW(dictItem);
    }catch (RuntimeException e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  /**
   * 根据字典ID禁用字典
   * @param id
   * @return
   */
  @ApiOperation(value = "禁用字典")
  @PutMapping("/disable")
  public ResponseModel disable(@ApiParam(name = "字典ID") @RequestParam("id") String id){
    try {
      DictItemEntity dictItem = dictItemService.disable(id);
      return buildHttpResultW(dictItem);
    }catch (RuntimeException e){
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  /**
   * 创建字典明细项(单项)
   * @param dictItem
   * @param dictCode
   * @return
   */
  @ApiOperation(value = "创建字典明细项（单项）")
  @PostMapping("")
  public ResponseModel create(@ApiParam(name = "创建字典明细项") @RequestBody DictItemEntity dictItem,
                              @RequestParam(name = "dictCode") @ApiParam(name = "dictCode", value = "字典编码") String dictCode) {
    try {
      DictItemEntity result = dictItemService.create(dictCode, dictItem);
      return this.buildHttpResultW(result);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }
}
