package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.EnvironmentVariableEntity;
import com.bizunited.platform.core.service.EnvironmentVariableService;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

/**
 * EnvironmentVariableController
 *
 * @description:
 * @author: yanwe
 * @date: 15/May/2019 14:47
 */
@RestController
@RequestMapping("/v1/nebula/environmentVariables")
public class EnvironmentVariableController extends BaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentVariableController.class);

  @Autowired private EnvironmentVariableService environmentVariableService;

  @ApiOperation(value = "查询所有参数")
  @RequestMapping(value = "/findAll", method = RequestMethod.GET)
  public ResponseModel findAll() {
    try {
      return buildHttpResultW(environmentVariableService.findAll(), "");
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "分页查询参数")
  @RequestMapping(value = "/findByConditions", method = RequestMethod.GET)
  public ResponseModel findByConditions(
      @RequestParam(name = "paramCode") @ApiParam(name = "paramCode", value = "paramCode") String paramCode,
      @RequestParam(name = "paramKey") @ApiParam(name = "paramKey", value = "paramKey") String paramKey,
      @RequestParam(name = "paramValue") @ApiParam(name = "paramValue", value = "paramValue") String paramValue,
      @RequestParam(name = "paramType") @ApiParam(name = "paramType", value = "paramType") String paramType,
      @RequestParam(name = "paramStatus") @ApiParam(name = "paramStatus", value = "paramStatus") Integer paramStatus, Pageable pageable) {
    try {
      return buildHttpResultW(environmentVariableService.findByConditions(paramCode,paramKey,paramValue,paramType,paramStatus,pageable), "");
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "根据业务编号查询环境变量信息")
  @RequestMapping(value = "/findByCode", method = RequestMethod.GET)
  public ResponseModel findByCode(
      @RequestParam(name = "code") @ApiParam(name = "code", value = "全系统唯一的业务编码") String code) {
    try {
      return buildHttpResultW(environmentVariableService.findByCode(code));
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "根据key查询参数")
  @RequestMapping(value = "/findByKey", method = RequestMethod.GET)
  public ResponseModel findByKey(
      @RequestParam(name = "key") @ApiParam(name = "key", value = "key") String key) {
    try {
      return buildHttpResultW(environmentVariableService.findByKey(key), "");
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "新增/修改参数")
  @RequestMapping(value = "/save", method = RequestMethod.POST)
  public ResponseModel save(@ApiParam(name = "参数") @RequestBody EnvironmentVariableEntity entity) {
    try {
      return buildHttpResultW(environmentVariableService.save(entity), "");
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "启用参数")
  @RequestMapping(value = "/enable", method = RequestMethod.POST)
  public ResponseModel enable(
      @RequestParam(name = "id") @ApiParam(name = "id", value = "ID") String id) {
    try {
      return buildHttpResultW(environmentVariableService.enable(id),"");
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "禁用参数")
  @RequestMapping(value = "/disable", method = RequestMethod.POST)
  public ResponseModel disable(
      @RequestParam(name = "id") @ApiParam(name = "id", value = "ID") String id) {
    try {
      return buildHttpResultW(environmentVariableService.disable(id),"");
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "删除参数")
  @RequestMapping(value = "/delete", method = RequestMethod.POST)
  public ResponseModel delete(
      @RequestParam(name = "id") @ApiParam(name = "id", value = "ID") String id) {
    try {
      environmentVariableService.delete(id);
      return buildHttpResult();
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }
}
