package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.core.controller.model.ResponseCode;
import com.bizunited.platform.core.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * 技术中台上下文相关信息的http访问接口.
 * @author yinwenjie
 * @version V1.0
 */
@RestController
@RequestMapping(value="/v1/nebula/platforms")
public class PlatformContextController extends BaseController {

  @Autowired
  private PlatformContext platformContext;

  @ApiOperation(value = "确认当前技术中台是否已经成功启动了表单引擎子系统")
  @GetMapping("/isEnableKuiper")
  public ResponseModel isEnableKuiper() {
    try {
      boolean isEnableKuiper = platformContext.isEnableKuiper();
      ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E0, null);
      result.setData(isEnableKuiper);
      return result;
    } catch (Exception e) {
      return this.buildHttpResultForException(e);
    }
  }
  
  @ApiOperation(value = "确认当前技术中台是否已经成功启动了流程引擎子系统")
  @GetMapping("/isEnableTitan")
  public ResponseModel isEnableTitan() {
    try {
      boolean isEnableTitan = platformContext.isEnableTitan();
      ResponseModel result = new ResponseModel(new Date().getTime(), null, ResponseCode.E0, null);
      result.setData(isEnableTitan);
      return result;
    } catch (Exception e) {
      return this.buildHttpResultForException(e);
    }
  }

}