package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.RbacSettingEntity;
import com.bizunited.platform.core.service.security.RbacSettingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * rbac环境设置控制类，restfull风格接口
 * @Author: Paul Chan
 * @Date: 2019-11-25 16:58
 */
@RestController
@Api(tags = "rbac环境设置控制类")
@RequestMapping("/v1/nebula/rbac/setting")
public class RbacSettingController extends BaseController {

  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(RbacSettingController.class);

  @Autowired
  private RbacSettingService rbacSettingService;

  /**
   * rbac环境设置
   * @param setting
   * @return
   */
  @PatchMapping("")
  @ApiOperation("更新rbac环境设置")
  public ResponseModel update(@RequestBody RbacSettingEntity setting) {
    try {
      RbacSettingEntity rbacSetting = rbacSettingService.update(setting);
      return buildHttpResultW(rbacSetting);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  /**
   * 获取rbac环境设置
   * @return
   */
  @GetMapping("")
  @ApiOperation("获取rbac环境设置")
  public ResponseModel findRbacSetting() {
    try {
      RbacSettingEntity rbacSetting = rbacSettingService.findRbacSetting();
      return buildHttpResultW(rbacSetting);
    } catch (RuntimeException e) {
      return buildHttpResultForException(e);
    }
  }

}
