package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * DataViewAuthHorizontalEntity  数据视图横向权限
 * @author saturn
 */
@RestController
@RequestMapping("/v1/nebula/dataViewAuthHorizontals")
public class DataViewAuthHorizontalController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthHorizontalController.class);
  /**
   * 过滤字段
   */
  private static final String[] FIELDS_FILTERS = new String[]{"field","dataView","authRelations","authRelations.authHorizontal","authRelations.relation"};
  @Autowired
  private DataViewAuthHorizontalService dataViewAuthHorizontalService;

  /**
   * 创建数据视图横向权限
   * */
  @ApiOperation(value = "创建数据视图横向权限")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="authHorizontals" , value="创建数据视图横向权限") Set<DataViewAuthHorizontalEntity> authHorizontals) {
    try {
      Set<DataViewAuthHorizontalEntity> current = this.dataViewAuthHorizontalService.create(authHorizontals);
      return this.buildHttpResultW(current);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 更新数据视图横向权限
   * */
  @ApiOperation(value = "更新数据视图横向权限")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="authHorizontals" , value="更新数据视图横向权限") Set<DataViewAuthHorizontalEntity> authHorizontals,
                              @RequestParam("dataViewId") @ApiParam(name="dataViewId" , value="数据视图ID") String dataViewId) {
    try {
      Set<DataViewAuthHorizontalEntity> current = this.dataViewAuthHorizontalService.update(authHorizontals , dataViewId);
      return this.buildHttpResultW(current);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据指定的字段信息和数据视图ID，查询对应的横向权限信息
   * @param field 关联的 指定的用户权限筛选字段
   * @param dataViewId 数据视图ID
   */
  @ApiOperation(value = "根据指定的字段信息和数据视图ID，查询对应的横向权限信息")
  @RequestMapping(value="/findDetailsByFieldAndDataView" , method={RequestMethod.GET})
  public ResponseModel findDetailsByFieldAndDataView(@RequestParam("field") @ApiParam("关联的 指定的用户权限筛选字段") String field,@RequestParam("dataViewId") @ApiParam("数据视图ID") String dataViewId) {
    try { 
      DataViewAuthHorizontalEntity result = this.dataViewAuthHorizontalService.findDetailsByFieldAndDataView(field,dataViewId);
      return this.buildHttpResultW(result, FIELDS_FILTERS);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照关联的 对应的视图进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param dataView 关联的 对应的视图
   */
  @ApiOperation(value = "按照关联的 对应的视图进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsByDataView" , method={RequestMethod.GET})
  public ResponseModel findDetailsByDataView(@RequestParam("dataView") @ApiParam("关联的 对应的视图") String dataView) {
    try { 
      Set<DataViewAuthHorizontalEntity> result = this.dataViewAuthHorizontalService.findDetailsByDataViewCode(dataView);
      return this.buildHttpResultW(result, FIELDS_FILTERS);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      DataViewAuthHorizontalEntity result = this.dataViewAuthHorizontalService.findDetailsById(id);
      return this.buildHttpResultW(result, FIELDS_FILTERS);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
} 
