package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import com.bizunited.platform.core.service.dataview.DataViewAuthInterceptorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 数据视图权限拦截器控制器，restfull风格接口
 * @Author: Paul Chan
 * @Date: 2019-12-23 10:25
 */
@RestController
@Api(tags = "数据视图权限拦截器控制器")
@RequestMapping("/v1/nebula/dataViewAuthInterceptors")
public class DataViewAuthInterceptorController extends BaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthInterceptorController.class);

  @Autowired
  private DataViewAuthInterceptorService dataViewAuthInterceptorService;

  /**
   * 新增数据视图权限拦截器
   * @param interceptor
   * @return
   */
  @PostMapping("")
  @ApiOperation("新增数据视图权限拦截器")
  public ResponseModel create(@RequestBody DataViewAuthInterceptorEntity interceptor) {
    try {
      DataViewAuthInterceptorEntity interceptorEntity = dataViewAuthInterceptorService.create(interceptor);
      return buildHttpResultW(interceptorEntity);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  /**
   * 更新数据视图权限拦截器
   * @param interceptor
   * @return
   */
  @PatchMapping("")
  @ApiOperation("更新数据视图权限拦截器")
  public ResponseModel update(@RequestBody DataViewAuthInterceptorEntity interceptor) {
    try {
      DataViewAuthInterceptorEntity interceptorEntity = dataViewAuthInterceptorService.update(interceptor);
      return buildHttpResultW(interceptorEntity);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  /**
   * 根据数据视图查询权限拦截器
   * @param dataViewId
   * @return
   */
  @GetMapping("findByDataView")
  @ApiOperation("根据数据视图查询权限拦截器")
  public ResponseModel findByDataView(@RequestParam @ApiParam(value = "数据视图编码", required = true) String dataViewCode) {
    try {
      DataViewAuthInterceptorEntity interceptor = dataViewAuthInterceptorService.findByDataView(dataViewCode);
      return buildHttpResultW(interceptor);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }
}
