package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.util.Set;

/**
 * 数据视图之横向数据权限信息
 */
@Entity
@Table(name="engine_dataview_auth_horizontal",indexes={@Index(columnList="data_view")})
@org.hibernate.annotations.Table(appliesTo = "engine_dataview_auth_horizontal" , comment = "数据视图之横向数据权限信息")
public class DataViewAuthHorizontalEntity extends UuidEntity{
  private static final long serialVersionUID = 1L;
  /**
   * 指定的用户权限筛选字段
   */
  @ManyToOne(fetch= FetchType.LAZY)
  @JoinColumn(name="field" , nullable=false , columnDefinition = "varchar(255) COMMENT '指定的用户权限筛选字段'")
  @SaturnColumn(description="指定的用户权限筛选字段")
  private DataViewFieldEntity field;

  /**
   * 权限类型
   * 1.用户
   * 2.角色
   * 3.岗位
   * 4.用户组
   * 5.组织机构
   */
  @Column(name="auth_type" , nullable=false, columnDefinition = "int(11) COMMENT '权限类型 1.用户 2.角色 3.岗位 4.用户组 5.组织机构'")
  @SaturnColumn(description="权限类型")
  private Integer authType;
  /**
   * 操作符类型
   */
  @Column(name="oprt_type" , length=32 , nullable=false , columnDefinition = "varchar(32) COMMENT '操作符类型'")
  @SaturnColumn(description="操作符类型")
  private String oprtType;
  /**
   * 参数来源类型：<br>
   * 2、固定值
   * 3、预制值
   */
  @Column(name="param_source_type" , nullable=false , columnDefinition = "int(11) COMMENT '参数来源类型：2、固定值 3、预制值'")
  @SaturnColumn(description="参数来源类型")
  private Integer paramSourceType = 3;
  /**
   * 参数类型：<br>
   * 支持：java.lang.String，java.util.Date，java八大基础类型
   */
  @Column(name="param_type" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '参数类型,支持：java.lang.String，java.util.Date，java八大基础类型'")
  @SaturnColumn(description="参数类型")
  private String paramType;
  /**
   * 如果参数来源类型为3（预制值）时，这里记录预制值的标识key
   */
  @Column(name="param_key" , length=64, nullable=true, columnDefinition = "varchar(64) COMMENT '如果参数来源类型为3（预制值）时，这里记录预制值的标识key'")
  @SaturnColumn(description="预制值标识")
  private String paramKey = "";
  /**
   * 如果当前参数来源类型为2（固定值）时，这里负责记录具体的固定值
   * 横向数据权限信息指定的权限领域
   */
  @OneToMany(fetch=FetchType.LAZY , mappedBy="authHorizontal")
  @SaturnColumn(description="权限领域")
  @OrderBy("sort_index")
  private Set<DataViewAuthHorizontalRelationEntity> authRelations;
  /**
   * 对应的数据视图
   */
  @ManyToOne(fetch= FetchType.LAZY)
  @JoinColumn(name="data_view" , nullable=false , columnDefinition = "varchar(255) COMMENT '对应的数据视图'")
  @SaturnColumn(description="对应的视图")
  private DataViewEntity dataView;

  /**
   * 排序字段
   */
  @Column(name="sort_index" , nullable=false , columnDefinition = "int(11) COMMENT '排序字段'")
  @SaturnColumn(description="横向数据权限排序")
  private Integer sortIndex;
  
  public DataViewFieldEntity getField() {
    return field;
  }

  public void setField(DataViewFieldEntity field) {
    this.field = field;
  }

  public Integer getAuthType() {
    return authType;
  }

  public void setAuthType(Integer authType) {
    this.authType = authType;
  }

  public String getOprtType() {
    return oprtType;
  }

  public void setOprtType(String oprtType) {
    this.oprtType = oprtType;
  }

  public Integer getParamSourceType() {
    return paramSourceType;
  }

  public void setParamSourceType(Integer paramSourceType) {
    this.paramSourceType = paramSourceType;
  }

  public String getParamType() {
    return paramType;
  }

  public void setParamType(String paramType) {
    this.paramType = paramType;
  }

  public String getParamKey() {
    return paramKey;
  }

  public void setParamKey(String paramKey) {
    this.paramKey = paramKey;
  }

  public DataViewEntity getDataView() {
    return dataView;
  }

  public void setDataView(DataViewEntity dataView) {
    this.dataView = dataView;
  }

  public Set<DataViewAuthHorizontalRelationEntity> getAuthRelations() {
    return authRelations;
  }

  public void setAuthRelations(Set<DataViewAuthHorizontalRelationEntity> authRelations) {
    this.authRelations = authRelations;
  }

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }
}
