package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 数据视图中的用户过滤信息
 * @author yinwenjie
 */
@Entity
@Table(name="engine_dataview_filter")
@org.hibernate.annotations.Table(appliesTo = "engine_dataview_filter" , comment = "数据视图中的用户过滤信息")
public class DataViewFilterEntity extends UuidEntity {

  private static final long serialVersionUID = -2848617563111826405L;
  /**
   * 对应的视图
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="data_view" , nullable=false, columnDefinition = "varchar(255) COMMENT '对应的视图'")
  @SaturnColumn(description="对应的视图")
  private DataViewEntity dataView;
  /**
   * 对应的结构字段
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="field" , nullable=false, columnDefinition = "varchar(255) COMMENT '结构字段'")
  @SaturnColumn(description="结构字段")
  private DataViewFieldEntity field;
  /**
   * 操作符类型<br>
   */
  @Column(name="op_type" , nullable=false, columnDefinition = "varchar(255) COMMENT '操作符类型'")
  @SaturnColumn(description="操作符类型")
  private String opType;
  /**
   * 字段排序
   */
  @Column(name="sort_index" ,  nullable=false, columnDefinition = "int(11) COMMENT '字段排序'")
  @SaturnColumn(description="字段排序")
  private Integer sortIndex = 1;
  /**
   * 是否可以不进行选择
   */
  @Column(name="nullable" , nullable=false, columnDefinition = "bit(1) COMMENT '是否可以不进行选择'")
  @SaturnColumn(description="是否可以不进行选择")
  private Boolean nullable = true;
  /**
   * 字段显示中文信息
   */
  @Column(name="display_name" , length=64 , nullable=false, columnDefinition = "varchar(255) COMMENT '字段显示中文信息'")
  @SaturnColumn(description="显示中文信息")
  private String displayName;
  public DataViewEntity getDataView() {
    return dataView;
  }
  public void setDataView(DataViewEntity dataView) {
    this.dataView = dataView;
  }
  public String getOpType() {
    return opType;
  }
  public void setOpType(String opType) {
    this.opType = opType;
  }
  public Integer getSortIndex() {
    return sortIndex;
  }
  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }
  public Boolean getNullable() {
    return nullable;
  }
  public void setNullable(Boolean nullable) {
    this.nullable = nullable;
  }
  public String getDisplayName() {
    return displayName;
  }
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }
  public DataViewFieldEntity getField() {
    return field;
  }
  public void setField(DataViewFieldEntity field) {
    this.field = field;
  }
}
