package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;
import java.util.Set;

/**
 * nebula服务方法详细描述
 * @author yinwenjie
 */
@ApiModel(value = "ServicableMethodEntity" , description="nebula服务方法详细描述")
@Entity
@Table(name="engine_service_method")
@org.hibernate.annotations.Table(appliesTo = "engine_service_method" , comment = "nebula服务方法详细描述")
public class ServicableMethodEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 7795122000695826215L;
  /**
   * 基于后端代码，服务层的服务源名。这个属性是服务源在系统中的唯一标示。例如UserTestService.createTest
   */
  @ApiModelProperty(name="name" , value="基于后端代码，服务层的服务源名。这个属性是服务源在系统中的唯一标示。例如UserTestService.createTest")
  @Column(name="name" , length=128 , nullable=false , unique=true, columnDefinition = "varchar(128) COMMENT '服务层的服务源名（唯一）'")
  @SaturnColumn(description="服务层的服务源名（唯一）")
  private String name = "";
  /**
   * 指示当前服务的中文描述
   */
  @ApiModelProperty(name="desc" , value="指示当前服务的中文描述")
  @Column(name="description" , length=512 , nullable=false, columnDefinition = "varchar(512) COMMENT '指示当前服务的中文描述'")
  @SaturnColumn(description="当前服务的中文描述")
  private String description = "";
  /**
   * 如果存在返回信息，且返回信息是一个业务对象，则可以使用该属性指定这个业务对象的哪些直接或间接属性不需要进行返回
   */
  @ApiModelProperty(name="returnPropertiesFilter" , value="如果存在返回信息，且返回信息是一个业务对象，则可以使用该属性指定这个业务对象的哪些直接或间接属性不需要进行返回"
      , notes="例如:\"name,myoder,record.name\"。表示这个返回对象中的两个直接属性name、myoder不需要返回，另外返回对象中有一个间接关联的对象record下的name属性也不需要返回")
  @Column(name="return_properties_filter" , nullable=false, columnDefinition = "varchar(255) COMMENT '如果存在返回信息，且返回信息是一个业务对象，则可以使用该属性指定这个业务对象的哪些直接或间接属性不需要进行返回'")
  @SaturnColumn(description="返回值过滤信息")
  private String returnPropertiesFilter;
  /**
   * 完整的表单引擎后端暴露方法名，包括包名、接口类名、方法名
   */
  @ApiModelProperty(name="methodName" , value="完整的表单引擎后端暴露方法名，包括包名、接口类名、方法名")
  @Column(name="method_name" , nullable=false, columnDefinition = "varchar(255) COMMENT '完整的表单引擎后端暴露方法名，包括包名、接口类名、方法名'")
  @SaturnColumn(description="后端暴露方法名")
  private String methodName;
  /**
   * 简单的方法名，只包括方法名本身，不包括包名、接口类名
   */
  @ApiModelProperty(name="simpleMethodName" , value="简单的方法名，只包括方法名本身，不包括包名、接口类名")
  @Column(name="simple_method_name" , length=128 , nullable=false, columnDefinition = "varchar(128) COMMENT '简单的方法名，只包括方法名本身，不包括包名、接口类名'")
  @SaturnColumn(description="简单的方法名")
  private String simpleMethodName;
  /**
   * 完整的接口名，包括包名和类名
   */
  @ApiModelProperty(name="interfaceName" , value="完整的接口名，包括包名和类名")
  @Column(name="interface_name" , nullable=false, columnDefinition = "varchar(255) COMMENT '完整的接口名，包括包名和类名'")
  @SaturnColumn(description="完整的接口名")
  private String interfaceName;
  /**
   * 返回信息是否为一个集合
   */
  @ApiModelProperty(name="returnCollection" , value="返回信息是否为一个集合")
  @Column(name="return_collection" , nullable=false, columnDefinition = "bit(1) COMMENT '返回信息是否为一个集合'")
  @SaturnColumn(description="返回信息是否为一个集合")
  private Boolean returnCollection; 
  /**
   * 返回参数类型可以为：
   * 1：java.lang.Void
   * 2：返回参数本身的泛型类型或基本类型
   * 3：分页Page类型
   * 4 : 其他任意类型
   */
  @ApiModelProperty(name="returnClassName" , value="返回参数的对象类型，（没有返回参数的，存java.lang.Void）")
  @Column(name="return_classname" , nullable=false, columnDefinition = "varchar(255) COMMENT '返回参数类型可以为：1：java.lang.Void 2：返回参数本身的泛型类型或基本类型  3：分页Page类型 4 : 其他任意类型 '")
  @SaturnColumn(description="返回参数类型")
  private String returnClassName;
  /**
   * 该方法对应的参数信息
   */
  @ApiModelProperty(name="properties" , value="该方法对应的参数信息")
  @OneToMany(fetch=FetchType.LAZY , mappedBy="serviceMethod")
  @SaturnColumn(description="方法对应的参数信息")
  private Set<ServicableMethodPropertyEntity> properties;
  /**
   * 该方法的应用范围
   */
  @ApiModelProperty(name="usedScope" , value="该方法的应用范围")
  @Column(name="used_scope" , length=10 , nullable=false, columnDefinition = "varchar(10) COMMENT '该方法的应用范围'")
  @SaturnColumn(description="方法应用范围")
  private String usedScope;
  
  @ApiModelProperty(name="recordQuery" , value="当前WRITE方法应用性质指定的详情查询方法名")
  @Column(name="record_query" , nullable=true, columnDefinition = "varchar(255) COMMENT '当前WRITE方法应用性质指定的详情查询方法名'")
  @SaturnColumn(description="当前WRITE方法应用性质指定的详情查询方法名")
  private String recordQuery;
  
  @ApiModelProperty(name="recordUpdate" , value="当前WRITE方法应用性质指定的更新方法名")
  @Column(name="record_update" , nullable=true, columnDefinition = "varchar(255) COMMENT '当前WRITE方法应用性质指定的更新方法名'")
  @SaturnColumn(description="当前WRITE方法应用性质指定的更新方法名")
  private String recordUpdate;
  
  public String getRecordQuery() {
    return recordQuery;
  }
  public void setRecordQuery(String recordQuery) {
    this.recordQuery = recordQuery;
  }
  public String getRecordUpdate() {
    return recordUpdate;
  }
  public void setRecordUpdate(String recordUpdate) {
    this.recordUpdate = recordUpdate;
  }
  public String getUsedScope() {
    return usedScope;
  }
  public void setUsedScope(String usedScope) {
    this.usedScope = usedScope;
  }
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public String getDescription() {
    return description;
  }
  public void setDescription(String description) {
    this.description = description;
  }
  public String getReturnPropertiesFilter() {
    return returnPropertiesFilter;
  }
  public void setReturnPropertiesFilter(String returnPropertiesFilter) {
    this.returnPropertiesFilter = returnPropertiesFilter;
  }
  public String getMethodName() {
    return methodName;
  }
  public void setMethodName(String methodName) {
    this.methodName = methodName;
  }
  public String getSimpleMethodName() {
    return simpleMethodName;
  }
  public void setSimpleMethodName(String simpleMethodName) {
    this.simpleMethodName = simpleMethodName;
  }
  public String getInterfaceName() {
    return interfaceName;
  }
  public void setInterfaceName(String interfaceName) {
    this.interfaceName = interfaceName;
  }
  public Boolean getReturnCollection() {
    return returnCollection;
  }
  public void setReturnCollection(Boolean returnCollection) {
    this.returnCollection = returnCollection;
  }
  public String getReturnClassName() {
    return returnClassName;
  }
  public void setReturnClassName(String returnClassName) {
    this.returnClassName = returnClassName;
  }
  public Set<ServicableMethodPropertyEntity> getProperties() {
    return properties;
  }
  public void setProperties(Set<ServicableMethodPropertyEntity> properties) {
    this.properties = properties;
  }
}