package com.bizunited.platform.core.interceptor;

import com.bizunited.platform.core.repository.dataview.analysis.SqlAnalysis;

/**
 * 数据视图拦截器接口，此拦截器作用于数据视图执行时sql前，开发者可实现此接口并配置到数据视图中
 * @Author: Paul Chan
 * @Date: 2019-12-20 17:54
 */
public interface DataViewAuthInterceptor {

  /**
   * 自定义拦截接口，开发者可实现此接口实现自己的处理逻辑，
   * 并在数据视图中配置实现类的路径，在数据视图sql执行之前，会调用此接口
   * 代码示例(将当前登录用户名做为筛选条件)：
   * <p>
   *   <code>
   *    public void intercept(SqlAnalysis sqlAnalysis) {
   *     // 获取登录用户的用户名
   *     SecurityContext securityContext = SecurityContextHolder.getContext();
   *     Validate.notNull(securityContext , "未发现任何用户权限信息!!");
   *     Authentication authentication = securityContext.getAuthentication();
   *     Validate.notNull(authentication , "未发现任何用户登录信息!!");
   *     String userName = authentication.getName();
   *     // 获取到当前sql
   *     Map<SQLCorrelationEnum, Object> result = sqlAnalysis.getResult();
   *     String sql = (String) result.get(SQLCorrelationEnum.RESULT_SQL);
   *     // 将参数设置到参数池中
   *     SQLParamModel spm = new SQLParamModel();
   *     spm.setParamName("name");
   *     spm.setTransferType(2);
   *     spm.setParamType("java.lang.String");
   *     spm.setParamKey("name");
   *     // 这里设置参数的下标计数
   *     int count = (int) result.remove(SQLCorrelationEnum.COUNTER);
   *     spm.setIndex(count++);
   *     result.put(SQLCorrelationEnum.COUNTER, count);
   *     spm.setValue(userName);
   *     spm.setSource(DataViewAuthHorizontalEntity.class);
   *     Set<SQLParamModel> values = (LinkedHashSet<SQLParamModel>) result.get(SQLCorrelationEnum.AUTH_HORIZONTAL_VALUES);
   *     values.add(spm);
   *     // 重新组装sql
   *     sql = "select * from (" + sql + ") a111 where a111.name=?";
   *     result.put(SQLCorrelationEnum.RESULT_SQL, sql);
   *   }
   *   </code>
   * </p>
   * @param sqlAnalysis
   */
  public void intercept(SqlAnalysis sqlAnalysis);

}
