package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.RemoteServiceAddressEntity;
import com.bizunited.platform.core.repository.internal.RemoteServiceAddressRepositoryCustom;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

/**
 * RemoteServiceAddressRepository
 *
 * @description:
 * @author: yanwe
 * @date: 06/May/2019 10:10
 */
@Repository("RemoteServiceAddressRepository")
public interface RemoteServiceAddressRepository
    extends JpaRepository<RemoteServiceAddressEntity, String>,
        JpaSpecificationExecutor<RemoteServiceAddressEntity>,
        RemoteServiceAddressRepositoryCustom {

  /**
   * 根据编码查询
   *
   * @param code
   * @return
   */
  RemoteServiceAddressEntity findByCode(String code);

  /**
   * 根据别名查询
   *
   * @param alias
   * @return
   */
  RemoteServiceAddressEntity findByAlias(String alias);
}
