package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import javax.transaction.Transactional;
import java.util.Set;

/**
 * DataViewAuthHorizontalEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_DataViewAuthHorizontalRepository")
public interface DataViewAuthHorizontalRepository
    extends
      JpaRepository<DataViewAuthHorizontalEntity, String>
      ,JpaSpecificationExecutor<DataViewAuthHorizontalEntity>
  {
  /**
   * 根据指定的字段信息和数据视图ID，查询对应的横向权限信息
   * @param fieldId
   * */
  @Query("select dataViewAuthHorizontalEntity from DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity "
      + " left join fetch dataViewAuthHorizontalEntity.field dataViewAuthHorizontalEntity_field "
      + " left join fetch dataViewAuthHorizontalEntity.dataView dataViewAuthHorizontalEntity_dataView "
      + " left join fetch dataViewAuthHorizontalEntity.authRelations dataViewAuthHorizontalEntity_authRelations "
       + " where dataViewAuthHorizontalEntity_field.id = :fieldId and dataViewAuthHorizontalEntity_dataView.id = :dataViewId")
  public DataViewAuthHorizontalEntity findDetailsByFieldAndDataView(@Param("fieldId") String fieldId,@Param("dataViewId") String dataViewId);
  /**
   * 按照对应的视图进行详情查询（包括关联信息）已设置的当前数据视图的横向权限
   * @param dataViewCode
   * */
  @Query("select distinct dataViewAuthHorizontalEntity from DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity "
      + " left join fetch dataViewAuthHorizontalEntity.field dataViewAuthHorizontalEntity_field "
      + " left join fetch dataViewAuthHorizontalEntity.dataView dataViewAuthHorizontalEntity_dataView "
      + " left join fetch dataViewAuthHorizontalEntity.authRelations dataViewAuthHorizontalEntity_authRelations "
       + " where dataViewAuthHorizontalEntity_dataView.code = :dataViewCode order by dataViewAuthHorizontalEntity.sortIndex")
  public Set<DataViewAuthHorizontalEntity> findDetailsByDataViewCode(@Param("dataViewCode") String dataViewCode);
  
  /**
   * 按照对应的多个视图进行详情查询（包括关联信息）已设置的当前数据视图的横向权限
   * @param dataViewId
   * */
  @Query("select distinct dataViewAuthHorizontalEntity from DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity "
      + " left join fetch dataViewAuthHorizontalEntity.field dataViewAuthHorizontalEntity_field "
      + " left join fetch dataViewAuthHorizontalEntity.dataView dataViewAuthHorizontalEntity_dataView "
      + " left join fetch dataViewAuthHorizontalEntity.authRelations dataViewAuthHorizontalEntity_authRelations "
      + " where dataViewAuthHorizontalEntity_dataView.id in (:dataViewIds)")
  public Set<DataViewAuthHorizontalEntity> findDetailsByDataViewIds(@Param("dataViewIds") String[] dataViewIds);
  
  /**
   * 按照主键进行详情查询（包括关联信息）已设置的当前数据视图的横向权限
   * @param id 主键
   * */
  @Query("select distinct dataViewAuthHorizontalEntity from DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity "
      + " left join fetch dataViewAuthHorizontalEntity.field dataViewAuthHorizontalEntity_field "
      + " left join fetch dataViewAuthHorizontalEntity.dataView dataViewAuthHorizontalEntity_dataView "
      + " left join fetch dataViewAuthHorizontalEntity.authRelations dataViewAuthHorizontalEntity_authRelations "
      + " where dataViewAuthHorizontalEntity.id=:id ")
  public DataViewAuthHorizontalEntity findDetailsById(@Param("id") String id);


  /**
   * 根据视图id 统计存在的横向数据权限
   * @param dataViewId
   * @return
   */
  @Query("select count(*) from DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity "
      + " left join dataViewAuthHorizontalEntity.dataView dataViewAuthHorizontalEntity_dataView "
      + " where dataViewAuthHorizontalEntity_dataView.id = :dataViewId")
  public int countAuthHorizontals(@Param("dataViewId") String dataViewId);

  /**
   * 根据视图ID，删除横向权限信息
   * @param dataViewId
   */
  @Modifying
  @Transactional
  @Query("delete from DataViewAuthHorizontalEntity m where m.dataView.id = :dataViewId")
  public void deleteByDataView(@Param("dataViewId") String dataViewId);
}