package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * 实现mysql的sql分析，在执行sql前，对sql进行分页、参数、权限等处理
 *
 * @Author: Paul Chan
 * @Date: 2019-10-09 16:36
 */
public class MysqlAnalysis extends AbstractSqlAnalysis {


  public MysqlAnalysis(DataViewEntity dataView, Set<DataViewFilterEntity> filters, Set<DataViewSystemEntity> systemParams,
                       Set<DataViewAuthHorizontalEntity> authHorizontals, Set<DataViewAuthVerticalEntity> authVerticals,
                       InvokeParams params, Pageable pageable, Set<DataViewFieldEntity> allFileds, DataViewAuthInterceptorEntity dataViewAuthInterceptor) {
    super(dataView, filters, systemParams, authHorizontals, authVerticals, params, pageable, allFileds, dataViewAuthInterceptor);
  }

  @Override
  public void analysis() {
    super.analysis();
    this.pageAnalysis();
  }

  /**
   * 分页处理
   */
  private void pageAnalysis() {
    if (pageable == null || CollectionUtils.isEmpty(result)) {
      return;
    }
    //两部分解析
    //1.先解析count语句
    String prePageSQL = result.remove(SQLCorrelationEnum.RESULT_SQL).toString();
    String countSQL = String.format("select count(*) from (%s) a", prePageSQL);
    result.put(SQLCorrelationEnum.PRE_ORDER_PAGE_SQL, countSQL);
    String pageSQL = String.format("%s limit %s,%s", prePageSQL, pageable.getPageNumber() * pageable.getPageSize(), pageable.getPageSize());
    result.put(SQLCorrelationEnum.RESULT_SQL,pageSQL);
  }

  @Override
  public String concatSql(String... strs) {
    if (strs == null || strs.length == 0) {
      return Constants.EMPTY_CHAR;
    }
    StringBuilder sb = new StringBuilder("concat(");
    sb.append(StringUtils.join(strs, ",")).append(")");
    return sb.toString();
  }

}
