package com.bizunited.platform.core.repository.internal;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.core.entity.DynamicTaskSchedulerLogEntity;

/**
 * @author yinwenjie
 */
@Repository("DynamicTaskSchedulerLogRepositoryImpl")
public class DynamicTaskSchedulerLogRepositoryImpl implements DynamicTaskSchedulerLogRepositoryCustom {
  
  /**
   * 日志
   */
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String TASK_ID = "taskId";
  private static final String SUCCESS = "success";
  
  @SuppressWarnings("unchecked")
  @Override
  public Page<DynamicTaskSchedulerLogEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
    /*
     * -按照任务id编号(一定有)、日志类型、日志时间（只有一个，这里要自行计算开始和结束时间）
     * */
    String hql = "from DynamicTaskSchedulerLogEntity dtl left join fetch dtl.dynamicTaskScheduler dt where 1 = 1";
    String countSql = "select count(*) from engine_dynamic_task_log dtl where 1 = 1";
    // 任务id编号(一定有)
    Object taskId = conditions.get(TASK_ID);
    Validate.notNull(taskId , "进行查询是，任务id编号必须传入");
    hql += " AND dt.id = :taskId ";
    countSql += " AND dtl.dynamic_task = :taskId ";
    // 日志类型
    Object success = conditions.get(SUCCESS);
    if(success != null) {
      hql += " AND dtl.success = :success ";
      countSql += " AND dtl.is_success = :success ";
    }
    // 日志时间
    Object logtime = conditions.get("logtime");
    if (logtime != null) {
      hql += " AND dtl.startTime >= :startTime AND dtl.startTime <= :endTime ";
      countSql += " AND dtl.start_time >= :startTime AND dtl.start_time <= :endTime ";
    }
    hql += " order by dtl.startTime desc ";

    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createNativeQuery(countSql);
    // 任务id编号(一定有)
    query.setParameter(TASK_ID, taskId);
    countQuery.setParameter(TASK_ID, taskId);
    // 日志类型
    if(success != null) {
      Boolean currentSuccess = Boolean.valueOf(success.toString());
      query.setParameter(SUCCESS, currentSuccess);
      countQuery.setParameter(SUCCESS, Boolean.TRUE.equals(currentSuccess)?1:0);
    }
    // 运行状态
    if (logtime != null) {
      String logtimeValue = logtime.toString();
      String startTimeValue = StringUtils.join(logtimeValue, " 00:00:00");
      String endTimeValue = StringUtils.join(logtimeValue, " 23:59:59");
      SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      Date startTime;
      Date endTime;
      try {
        startTime = dataFormat.parse(startTimeValue);
        endTime = dataFormat.parse(endTimeValue);
      } catch (ParseException e) {
        throw new IllegalArgumentException(e);
      }
      query.setParameter("startTime", startTime);
      countQuery.setParameter("startTime", startTime);
      query.setParameter("endTime", endTime);
      countQuery.setParameter("endTime", endTime);
    }
    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<DynamicTaskSchedulerLogEntity> results = query.getResultList();

    // 查询总数量信息
    BigInteger count = (BigInteger)countQuery.getResultList().get(0);
    return new PageImpl<>(results,pageable,count.longValue());
  }
}