package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.core.entity.UserGroupEntity;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

import java.util.List;
import java.util.Map;

public class UserGroupRepositoryImpl implements UserGroupRepositoryCustom{
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String GROUP_NAME = "groupName";
  private static final String STATUS = "status";
  @SuppressWarnings("unchecked")
  @Override
  public Page<UserGroupEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
    /*
     * 目前的查询条件是：表单名、业务领域、项目名
     * */
    String hql = "from UserGroupEntity ue where 1=1 ";
    String countHql = "select count(*) from UserGroupEntity ue where 1=1 ";

    // 表单名name
    Object groupName = conditions.get(GROUP_NAME);
    if(groupName != null) {
      hql += " AND ue.groupName = :groupName ";
      countHql += " AND ue.groupName = :groupName ";
    }
    // 状态
    Object status = conditions.get(STATUS);
    if(status != null) {
      hql += " AND ue.tstatus = :status ";
      countHql += " AND ue.tstatus = :status ";
    }
    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createQuery(countHql);
    if(groupName != null) {
      query.setParameter(GROUP_NAME, groupName);
      countQuery.setParameter(GROUP_NAME, groupName);
    }
    if(status != null) {
      query.setParameter(STATUS, status);
      countQuery.setParameter(STATUS, status);
    }
    // 构造返回信息和最新的分页结果
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<UserGroupEntity> resutls = query.getResultList();
    // 查询总数量信息
    long count = (long)countQuery.getResultList().get(0);
    return new PageImpl<>(resutls,pageable,count);
  }
}