package com.bizunited.platform.core.service;

import com.bizunited.platform.core.entity.DictEntity;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * DictService
 * @description: 系统数据字典信息服务定义
 * @author: yanwe
 * @date: 11/Feb/2019 10:32
 */
public interface DictService {
  /**
   * 查询所有字典类
   * @return
   */
  List<DictEntity> findAll();
  /**
   * 查询启用状态与删除状态查询字典
   * @param dictStatus
   * @return
   */
  List<DictEntity> findByStatus(Boolean dictStatus);
  /**
   * 根据条件查询数据字典
   * @param dictCode
   * @param dictTitle
   * @param dictType
   * @param dictStatus
   * @return
   */
  Page<DictEntity> findByConditions(String dictCode, String dictTitle,String dictType, Boolean dictStatus, Pageable pageable);
  /**
   * 根据一个或者多个ID信息，查询字典明细信息，包括字典的各种关联信息（但是不包括下级关联信息）
   * @param dictIds
   * @return
   */
  Set<DictEntity> findDetailsByIds(String[] dictIds);
  /**
   * 按照指定的数据字典的ID信息，查询最终满足这些id编号的数据条目。<br>
   * 这个方法一般用于验证一批给定的id，是否都能在系统中找到对应的数据
   * @param ids 指定的id信息
   * @return 满足的条目数量将会被返回
   */
  int countByIds(String[] ids);
  /**
   * 创建字典类
   * @param dictEntity
   * @return
   */
  DictEntity create(DictEntity dictEntity,String categoryId);
  /**
   * 修改字典类
   * @param dictEntity
   * @return
   */
  DictEntity update(DictEntity dictEntity,String categoryId);
  /**
   * 选择一个字典类，复制升级
   * @param newDictCode
   * @param dictCode
   * @return
   */
  DictEntity upgrade(String newDictCode, String dictCode);
  /**
   * 上架字典
   * @param dictCode
   * @return
   */
  DictEntity onshelf(String dictCode);
  /**
   * 删除某字典
   * @param dictCode
   * @return
   */
  void delete(String dictCode);

  /**
   * 根据编码查询
   * @param dictCode
   * @return
   */
  DictEntity findByDictCode(String dictCode);
}
