package com.bizunited.platform.core.service;

import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import com.bizunited.platform.saturn.model.PersistentRelation;

import java.util.List;

/**
 * 和柯伊伯骨架静态模型信息相关的服务封装定义
 * @author yinwenjie
 */
public interface NebulaStaticPersistentService {
  
  /**
   * 查询系统中目前所有可用的静态模型信息，但是只包括静态模型本身的描述，不包括模型的一般属性描述和关联属性描述
   * @return
   */
  public List<PersistentClass> findAllPersistentClasses();
  
  /**
   * 当前接口用于查询系统中目前所有可用的主静态模型信息，但是只包括静态模型本身的描述，不包括模型的一般属性描述和关联属性描述
   * @return
   */
  public List<PersistentClass> findAllMainPersistentClasses();
  
  /**
   * 通过指定的静态模型完整类名，获得这个静态模型在Saturn扫描组件中的定义（SaturnContext）
   * @param className 指定的静态模型完整类名
   * @return 
   */
  public PersistentClass findByPersistentClass(String className);
  
  /**
   * 查询和className中propertyName对应的关联属性名。举个例子：A类中的a属性和B类中的b属性对应（比如ManyToMany关联），
   * 则如果这里的传参是A class name和a属性名，那么该方法就会返回B模型类中的b属性信息，反之亦然。
   */
  public PersistentRelation findByTargetPropertyName(String className, String propertyName);
  
  /**
   * 按照指定的类名，查询这个静态模型下面所有的一般属性信息
   * @param className
   * @return
   */
  public PersistentProperty findPkPropertyByClass(String className);
}