package com.bizunited.platform.core.service;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.script.model.ScriptInputParamsModel;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Map;

/**
 * ScriptService
 *
 * @description:
 * @author: yanwe
 * @date: 27/May/2019 15:49
 */

public interface ScriptService {

  /**
   * 分页查询
   * @param pageable
   * @param name
   * @param language
   * @return
   */
  Page<ScriptEntity> findByConditions(Pageable pageable, String name, String language);

  /**
   * 根据id查询
   * @param scriptId
   * @return
   */
  ScriptEntity findById(String scriptId);

  /**
   * 根据名称查询
   * @param name
   * @return
   */
  ScriptEntity findByName(String name);

  /**
   * 获取脚本内容根据脚本唯一识别名进行查询
   * @param scriptId
   * @return
   */
  String findContentByName(String scriptName);
  
  /**
   * 获取脚本内容
   * @param scriptId
   * @return
   */
  String findContentById(String scriptId);

  /**
   * 更新实体与脚本内容
   * @param scriptEntity
   * @param scriptContent
   * @return
   */
  ScriptEntity update(ScriptEntity scriptEntity, String scriptContent);

  /**
   * 新建
   * @param scriptEntity
   * @param scriptContent
   * @return
   */
  ScriptEntity create(ScriptEntity scriptEntity, String scriptContent);

  /**
   * 执行一个脚本的调用
   * @param params
   * @param scriptId
   * @return
   * @throws InvokeProxyException
   */
  Map<String,Object> invoke(String scriptId,Map<String, Object> params) throws InvokeProxyException;


  /**
   * 执行多个脚本的调用
   * @param model
   * @return
   * @throws InvokeProxyException
   */
  Object invoke(ScriptInputParamsModel model) throws InvokeProxyException;

}
