package com.bizunited.platform.core.service.dataview;

import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewEntity;

import java.util.Set;

/**
 * DataViewAuthHorizontalEntity业务模型的服务层接口定义
 * @author saturn
 */
public interface DataViewAuthHorizontalService {
  /**
   * 创建横向权限对象集合
   */
  public Set<DataViewAuthHorizontalEntity> create(Set<DataViewAuthHorizontalEntity> authHorizontals);

  /**
   * 创建时，验证横向权限信息
   * @param dataViewAuthHorizontalEntity
   */
  public void createValidation(DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity);

  /**
   * 更新横向权限对象集合
   * @param authHorizontals
   * @param dataViewId
   * @return
   */
  public Set<DataViewAuthHorizontalEntity> update(Set<DataViewAuthHorizontalEntity> authHorizontals , String dataViewId);

  /**
   * 更新时，验证横向权限信息
   * @param dataViewAuthHorizontalEntity
   */
  public void updateValidation(DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity);

  /**
   * 根据指定的字段信息和数据视图ID，查询对应的横向权限信息
   * @param field 关联的 指定的用户权限筛选字段
   * @param dataViewId 视图ID
   */
  public DataViewAuthHorizontalEntity findDetailsByFieldAndDataView( String field,String dataViewId);
  /**
   * 按照关联的 对应的视图进行详情查询（包括关联信息）,注意，这里返回的值已经不是JPA性质的对象了
   * @param dataViewCode 关联的 对应的视图code
   */
  public Set<DataViewAuthHorizontalEntity> findDetailsByDataViewCode(String dataViewCode);
  /**
   * 按照对应的多个视图进行详情查询（包括关联信息）已设置的当前数据视图的横向权限，注意，这里返回的值已经不是JPA性质的对象了
   * @param dataViewIds
   * */
  public Set<DataViewAuthHorizontalEntity> findDetailsByDataViewIds(String[] dataViewIds);
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  public DataViewAuthHorizontalEntity findDetailsById( String id);
  /**
   * 按照DataViewAuthHorizontalEntity的主键编号，查询指定的数据信息（不包括任何关联信息）
   * @param id 主键
   * */
  public DataViewAuthHorizontalEntity findById(String id);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  public void deleteById(String id);

  /**
   * 强制删除横向权限信息和横向权限领域信息
   * @param dataViewEntity
   */
  void deleteByDateView(DataViewEntity dataViewEntity);

}