package com.bizunited.platform.core.service.dataview;


import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import java.util.List;
import java.util.Set;

/**
 * DataViewFieldEntity业务模型的服务层接口定义
 * @author saturn
 */
public interface DataViewFieldService {
  /**
   * 在创建一个新的DataViewFieldEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  public void createValidation(DataViewFieldEntity dataViewFieldEntity);
  /**
   * 创建一个新的DataViewFieldEntity模型对象，ignoreValidate参数表示是否在进行创建前进行属性验证
   */
  public DataViewFieldEntity create(DataViewFieldEntity dataViewFieldEntity, boolean ignoreValidate);
  /**
   * 更新一个已有的DataViewFieldEntity模型对象，其主键属性必须有值
   */
  public DataViewFieldEntity update(DataViewFieldEntity dataViewFieldEntity);
  /**
   * 在更新一个已有的DataViewFieldEntity模型对象之前，检查对象各属性的正确性，其id属性必须有值
   */
  public void updateValidation(DataViewFieldEntity dataViewFieldEntity);
  /**
   * 按照对应的视图查询DataViewFieldEntity
   */
  public List<DataViewFieldEntity> findByDataView(String dataViewId);

  /**
   * 按照对应的视图查询设定了权限信息的DataViewFieldEntity
   * @param dataViewId
   * @return
   */
  public Set<DataViewFieldEntity> findAuthTypeFieldsByDataView(String dataViewId);
  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  public DataViewFieldEntity findDetailsById(String id);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  public void deleteById(String id);

  /**
   * find by code
   * @param code
   * @return
   */
  DataViewFieldEntity findByCode(String code);

  /**
   * 创建一个新的DataViewFieldEntity模型对象集合
   * @param fields
   * @param dataViewEntity
   */
  void create(Set<DataViewFieldEntity> fields, DataViewEntity dataViewEntity);

}