package com.bizunited.platform.core.service.init;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.io.InputStream;

/**
 * nebula菜单初始化
 * @Author: Paul Chan
 * @Date: 2019-10-15 16:52
 */
@Component("NebulaCompetenceInitProcess")
public class NebulaCompetenceInitProcess extends AbstractCompetenceInitProcess {

  private static final  Logger LOGGER = LoggerFactory.getLogger(NebulaCompetenceInitProcess.class);

  @Override
  public boolean doProcess() {
    return true;
  }

  @Override
  public void init() {
    try (InputStream is = NebulaCompetenceInitProcess.class.getClassLoader().getResourceAsStream("nebula-competences.json")) {
      super.initCompetences(is);
    } catch (IOException e) {
      LOGGER.error(e.getMessage(), e);
      throw new IllegalArgumentException(e.getMessage(), e);
    }
  }
}
