package com.bizunited.platform.core.service.invoke;

/**
 * 服务源调用响应链
 * @author yinwenjie
 */
public interface InvokeResponseHandle {  
  /**
   * 该ResponseFilter响应链中的这个处理节点是否在处理过程发生异常的情况下，继续进行处理。
   * @return 返回为true的情况，表示以上描述成立；其它情况表示不成立
   */
  public boolean handleException(InvokeProxyContext context);
  
  /**
   * 响应连需要实现的方法，当InvokeResponse处理链上的当前处理节点被调用时，该方法被激活
   * @param context 当前服务调用处理过程的上下文
   * @param chain 调用过程的控制器
   */
  public void doHandle(InvokeProxyContext context , HandleChain chain) throws InvokeProxyException; 
}