package com.bizunited.platform.core.service.invoke.model;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

/**
 * K-V结构的传参整合
 * 包含：</p>
 * 1.筛选条件InvokeOperations -> 前端传入的inputParamsModel中的filterParams</br>
 * 2.params -> 前端传入的inputParamsModel中的params</br>
 * 3.customData -> 前端传入的inputParamsModel中的customData</br>
 * 4.map<K,V>传参
 * 以上都会合并到invokeParams中
 */
public class InvokeParams implements Serializable{
  private static final long serialVersionUID = -1420712485773640690L;
  
  private Map<String, InvokeOperations> invokeParams = new HashMap<>();
  
  /**
   * 由于筛选参数后期可能支持不同类，但paramName相同
   * 再加上前端筛选参数都是以集合的形式传入，所以
   * 这里InvokeOperations中的key表示唯一键值，需要自行构造
   * @param key
   * @param model
   * @param existFilterParams  由于需要合并params，customData，Map<K,V>这些参数不带筛选值
   */
  public void add(String key, InvokeOperations model , boolean existFilterParams) {
    Validate.notBlank(key,"invokeParams，key值不能为空，请检查!!");
    Validate.isTrue(!containsKey(key), "invokeParams，%s值重复，请检查!!" , key);
    invokeParams.put(key, model);
  }
  
  public InvokeOperations get(String key) {
    Validate.notBlank(key,"获取invokeParams时，传入key值不能为空，请检查!!");
    return invokeParams.get(key);
  }
  
  public Object getValue(String key) {
    Validate.notBlank(key,"获取invokeParams时，传入key值不能为空，请检查!!");
    if(get(key) == null) {
      return null;
    }else {
      return invokeParams.get(key).getCompareValue();
    }
  }
  
  public boolean containsKey(String key) {
    return invokeParams.containsKey(key);
  }
  
  public boolean isEmpty() {
    return invokeParams.isEmpty();
  }
  
  
  public Set<String> keySet(){
    return invokeParams.keySet();
  }
  
  public Set<Entry<String,InvokeOperations>> entrySet(){
    return invokeParams.entrySet();
  }
  
  public InvokeOperations remove(String key) {
    return invokeParams.remove(key);
  }


  /**
   *排序方式   升序ASC   降序DESC 
   */
  public enum SortType{
    ASC,DESC
  }
  
  /**
   *SQL关系型运算符
   */
  public enum AndOrType{
    AND,OR
  }
  
  
  /**
   * NEQ不等于   EQ等于   GT大于   LT小于   GE大于等于   LE小于等于   NULL(is null)   NOTNULL(is not null)
   * LC_RC全闭区间(大于等于 到 小于等于)   LO_RC左开右闭区间(大于 到 小于等于)    LO_RO全开区间(大于 到 小于)    LC_RO左闭右开区间(大于等于 到 小于) 
   * BETWEEN全闭区间比较   IN包含   NIN不包含   DISTINCT去重复(注：在一个不包含子查询和union操作的SELECT SQL中只能出现一次)
   * 目前静态模板暂不支持LIKE的操作，动态视图支持LIKE
   */
  public enum OprtCharType{
    NEQ("!="),
    EQ("="),
    GT(">"),
    LT("<"),
    GE(">="),
    LE("<="),
    NULL("IS NULL"),
    NOTNULL("IS NOT NULL"),
    LC_RC("LC_RC"),
    LO_RC("LO_RC"),
    LO_RO("LO_RO"),
    LC_RO("LC_RO"),
    BETWEEN("BETWEEN"),
    IN("IN"),
    NIN("NOT IN"),
    LLIKE("LLIKE"),
    RLIKE("RLIKE"),
    LIKE("LIKE"),
    DISTINCT("DISTINCT");
    
    private String oprtValue;
    
    OprtCharType(String oprtValue) {
      this.oprtValue = oprtValue;
    }
    
    
    public static String getOprtValue(String code) {
      for(OprtCharType element : OprtCharType.values()) {
        if(StringUtils.equals(element.name(), code)) {
          return element.oprtValue;
        }
      }
      return null;
    }
  }
  
}
