package com.bizunited.platform.core.service.migrate;

import com.bizunited.platform.core.entity.MigrateConfigAnalysisEntity;
import com.bizunited.platform.core.entity.MigrateImportEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.security.Principal;
import java.util.Map;
import java.util.Set;

/**
 * MigrateImportServiceImpl
 * @description: 基本信息迁入功能的实现
 * @author: yanwe
 * @date: 03/Sep/2019 15:45
 */
@Service("MigrateImportService")
public interface MigrateImportService {
  /**
   * 分页查询上传记录
   *
   * @param conditions 查询条件，包括 编号,上传迁移文件类型,本次任务是否最终执行
   * @param pageable
   * @return
   */
  Page<MigrateImportEntity> findByCondition(Map<String, Object> conditions, Pageable pageable);
  /**
   * 上传ZIP文件，保存上传记录
   *
   * @param code 上传编码
   * @param migrateDesc 迁移描述
   * @param currentUser 当前登录人
   * @param file 文件
   * @return
   */
  MigrateImportEntity upload(
      String code, String migrateDesc, Principal currentUser, MultipartFile file);
  /**
   * 保存方法
   *
   * @param migrateImportEntity
   * @return
   */
  MigrateImportEntity create(MigrateImportEntity migrateImportEntity);

  /**
   * 分析上传的基础信息，返回分析结果
   *
   * @param migrateImportId 上传ZIP文件记录
   * @param currentUser 当前登陆人
   * @return
   */
  MigrateConfigAnalysisEntity analysisConfig(String migrateImportId, Principal currentUser);
  /**
   * 执行迁移上传的迁移文件
   *
   * @param migrateImportId
   * @param currentUser
   * @return
   */
  MigrateImportEntity execute(String migrateImportId, Principal currentUser);
  /**
   * 根据迁入的基础配置，查询历史分析记录
   *
   * @param importId
   * @return
   */
  Set<MigrateConfigAnalysisEntity> findConfigAnalysisByImport(String importId);
}