package com.bizunited.platform.core.service.script;

import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.repository.script.ScriptRepository;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.script.model.ScriptInputParamsModel;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;
import java.util.Set;

/**
 * JavaServiceInputHandle
 * 调用链-验证入参
 * @description:
 * @author: yanwe
 * @date: 27/May/2019 15:49
 */
@Component("JavaServiceInputHandle")
public class JavaServiceInputHandle implements InvokeRequestHandle {

  @Autowired
  private ScriptRepository scriptRepository;

  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    /*
     * 1、检查入参,是不是scriptIds,至少应该有一个。这些ids对应的脚本是不是存在
     * 特别是传入的InputParams对象
     * 2、拆分到上下文ServicableContext中,在第一步获取的入参key->value的信息
     * 3、从scriptService中验证相关groovy的内容
     *
     * */

    // 1、=======验证参数
    ScriptInputParamsModel model = (ScriptInputParamsModel)context.getChainParam("scriptInputParamsModel");
    Validate.notNull(model,"传入groovy变量参数不能为空！");
    List<String> scriptIds = model.getScriptIds();
    Validate.notEmpty(model.getScriptIds(),"传入脚本id不能为空！");
    context.setChainParam("scriptIds",scriptIds);

    for(String id: scriptIds){
      Optional<ScriptEntity> op = scriptRepository.findById(id);
      Validate.isTrue(op.isPresent(),"传入groovy脚本id未能查询到实体，请检查！");
    }
    Validate.notEmpty(scriptIds,"传入groovy脚本id不能为空！");

    //2、======
    Set<String> keys = model.keySet();
    if(!CollectionUtils.isEmpty(keys)){
      for(String key: keys){
        context.setChainParam(key,model.getParams(key));
      }
    }

    chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
  }
}