package com.bizunited.platform.core.service.serviceable.handle;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.HandleChain.ChainLogic;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import org.springframework.stereotype.Component;

/**
 * 该链的职责是从上下文中拿取handler中的临时处理结果，不做任何的处理，直接返回
 */
@Component("SpringMVCResponseHandle")
public class SpringMVCResponseHandle implements InvokeResponseHandle {
  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.invoke.InvokeResponseHandle#handleException()
   */
  @Override
  public boolean handleException(InvokeProxyContext servicableContext) {
    return false;
  }
  
  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.invoke.InvokeResponseHandle#doHandle(com.bizunited.platform.core.service.invoke.ServicableContext, com.bizunited.platform.core.service.invoke.HandleChain)
   */
  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
	/*
	 * SpringMVC中，不需要对handler的结果做处理，一切交由controller的白名单过滤机制处理并返回
	 * 注：该responseFilter没有设置出现异常后，让后续的response链继续处理
     */
    if(context.isException()) {
      chain.doHandle(context, ChainLogic.BREAK);
    }
    chain.doHandle(context, ChainLogic.CONTINUE);
  }
}