/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.rbac.server.service.CompetenceService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.CompetenceVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.rbac.server.vo.UserVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/competences"})
public class CompetenceController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompetenceController.class);
    @Autowired
    private CompetenceService competenceService;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;

    @ApiOperation(value="\u521b\u5efa\u65b0\u529f\u80fd\uff0c\u521b\u5efa\u65b0\u529f\u80fd\u662f\u5176URL\u4fe1\u606f\u5fc5\u987b\u662f\u552f\u4e00\u7684")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@RequestBody @ApiParam(name="comp", value="\u9700\u8981\u65b0\u589e\u7684\u529f\u80fd\u5bf9\u8c61\u4fe1\u606f ") CompetenceVo comp) {
        try {
            CompetenceVo competence = this.competenceService.create(comp);
            return this.buildHttpResultW(competence, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u529f\u80fd\u4fe1\u606f\uff0c\u53ea\u80fd\u4fee\u6539\u5bf9\u8c61\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\uff08\u76ee\u524d\u53ea\u80fd\u7f16\u8f91url\uff0c\u529f\u80fd\u4e2d\u6587\u8bf4\u660e\uff09\u3002")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel update(@RequestBody @ApiParam(name="comp", value="\u9700\u8981\u4fee\u6539\u7684\u529f\u80fd\u5bf9\u8c61\u4fe1\u606f") CompetenceVo comp) {
        try {
            CompetenceVo competence = this.competenceService.update(comp);
            return this.buildHttpResultW(competence, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u66f4\u6539\u529f\u80fd\u72b6\u6001\uff0c\u4ee5\u4fbf\u5b9e\u73b0\u529f\u80fd\u7684\u542f\u7528/\u7981\u7528\u529f\u80fd\uff0c\u6ce8\u610f\uff0c\u4e00\u65e6\u7236\u7ea7\u529f\u80fd\u7684\u72b6\u6001\u53d1\u751f\u53d8\u66f4\uff0c\u90a3\u4e48\u5176\u6240\u6709\u5b50\u7ea7\u72b6\u6001\uff08\u591a\u7ea7\uff09\u90fd\u4f1a\u53d1\u751f\u53d8\u5316")
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.PATCH})
    public ResponseModel updateStatus(@RequestParam(name="id") @ApiParam(name="id", value="\u529f\u80fd\u4fe1\u606fid") String id, @RequestParam(name="flag") @ApiParam(name="flag", value="flag \u6807\u8bc6\uff08true\uff1a\u542f\u7528\u64cd\u4f5c\uff1bfalse\uff1a\u7981\u7528\u64cd\u4f5c\uff09") Boolean flag) {
        try {
            CompetenceVo competence = this.competenceService.updateStatus(id, flag);
            return this.buildHttpResultW(competence, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5efa\u7acb\u6307\u5b9a\u89d2\u8272\u548c\u6307\u5b9a\u529f\u80fd\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @RequestMapping(value={"/bindCompetence"}, method={RequestMethod.PATCH})
    public ResponseModel bindCompetence(@RequestParam(name="roleId") @ApiParam(name="roleId", value="\u6307\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\u4fe1\u606f") String roleId, @RequestParam(name="competenceIds") @ApiParam(name="competenceIds", value="\u6307\u5b9a\u7684\u529f\u80fd\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] competenceIds) {
        try {
            this.competenceService.bindCompetence(roleId, competenceIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u53d6\u6d88\u6307\u5b9a\u89d2\u8272\u548c\u6307\u5b9a\u529f\u80fd\u7684\u7ed1\u5b9a\u5173\u7cfb")
    @RequestMapping(value={"/unbindCompetence"}, method={RequestMethod.PATCH})
    public ResponseModel unbindCompetence(@RequestParam(name="roleId") @ApiParam(name="roleId", value="\u6307\u5b9a\u7684\u89d2\u8272\u7f16\u53f7\u4fe1\u606f") String roleId, @RequestParam(name="competenceIds") @ApiParam(name="competenceIds", value="\u6307\u5b9a\u7684\u529f\u80fd\u7f16\u53f7\u4fe1\u606f(\u53ef\u4e00\u4e2a\u662f\u4e00\u4e2a\u6216\u8005\u591a\u4e2a)") String[] competenceIds) {
        try {
            this.competenceService.unbindCompetence(roleId, competenceIds);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5220\u9664\u6307\u5b9a\u7684\u529f\u80fd", notes="\u5982\u679c\u5f53\u524d\u529f\u80fd\u5b58\u5728\u4e0b\u7ea7\u5173\u8054\u529f\u80fd\uff0c\u5219\u4e0d\u80fd\u8fdb\u884c\u5220\u9664")
    @RequestMapping(value={"/{competenceId}"}, method={RequestMethod.DELETE})
    public ResponseModel deleteById(@PathVariable(name="competenceId") @ApiParam(name="competenceId", value="\u6307\u5b9a\u7684\u529f\u80fd\u7f16\u53f7") String competenceId) {
        try {
            this.competenceService.deleteById(competenceId);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="")
    @RequestMapping(value={"/findByUrlResource"}, method={RequestMethod.GET})
    public ResponseModel findByUrlResource(@RequestParam(name="resources") @ApiParam(name="resources", value="") String[] resources, HttpServletRequest request) {
        try {
            Principal userPrincipal = this.getPrincipal();
            JSONArray results = this.competenceService.findByUrlResource(resources, userPrincipal);
            return this.buildHttpResult(results);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u529f\u80fd\u4e2d\u7684viewItem\u5c5e\u6027\uff0c \u67e5\u8be2\u6ee1\u8db3\u6761\u4ef6\u7684\u6240\u6709\u529f\u80fd\u4fe1\u606f\uff08\u6309\u7167sortIndex\u8fdb\u884c\u6392\u5e8f\uff09")
    @RequestMapping(value={"/findByViewItem"}, method={RequestMethod.GET})
    public ResponseModel findByViewItem(@RequestParam(name="viewItem") @ApiParam(name="viewItem", value="\u662f\u5426\u662f\u529f\u80fd\u83dc\u5355\u4e0a\u7684\u529f\u80fd\u680f\u76ee1\uff1a\u9700\u8981\u663e\u793a\u7684\uff1b0\uff1a\u4e0d\u9700\u8981\u663e\u793a\u7684") Boolean viewItem) {
        try {
            JSONArray results = this.competenceService.findByViewItem(viewItem);
            return this.buildHttpResult(results);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u529f\u80fd\u4e2d\u7684viewItem\u5c5e\u6027\u3001\u72b6\u6001\u5c5e\u6027\uff0c \u67e5\u8be2\u6ee1\u8db3\u6761\u4ef6\u7684\u6240\u6709\u529f\u80fd\u4fe1\u606f\uff08\u6309\u7167sortIndex\u8fdb\u884c\u6392\u5e8f\uff09")
    @RequestMapping(value={"/findByViewItemAndStatus"}, method={RequestMethod.GET})
    public ResponseModel findByViewItemAndStatus(@RequestParam(name="viewItem") @ApiParam(name="viewItem", value="\u662f\u5426\u662f\u529f\u80fd\u83dc\u5355\u4e0a\u7684\u529f\u80fd\u680f\u76ee1\uff1a\u9700\u8981\u663e\u793a\u7684\uff1b0\uff1a\u4e0d\u9700\u8981\u663e\u793a\u7684") Boolean viewItem, @RequestParam(name="tstatus") @ApiParam(name="tstatus", value="\u72b6\u6001\u4fe1\u606f\uff0c1\uff1a\u6b63\u5e38\uff1b0\uff1a\u7981\u7528") Integer tstatus) {
        try {
            JSONArray results = this.competenceService.findByViewItemAndStatus(viewItem, tstatus);
            return this.buildHttpResult(results);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value=" \u8be5\u65b9\u6cd5\u6309\u7167\u5f53\u524d\u64cd\u4f5c\u8005\u6240\u62e5\u6709\u7684\u4e00\u4e2a\u6216\u8005\u591a\u4e2a\u89d2\u8272\u4fe1\u606f\u7684name\u4fe1\u606f\uff0c1.\u5bf9\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u540d\u79f0\u4e0eyml\u914d\u7f6e\u7684\u7ba1\u7406\u5458\u89d2\u8272\u4fe1\u606f\u53d6\u4ea4\u96c6\uff0c\u5224\u5b9a\u662f\u5426\u5177\u6709\u7ba1\u7406\u5458\u89d2\u8272,\u5982\u679c\u5177\u6709\u7ba1\u7406\u5458\u6743\u9650\uff0c\u8be5\u63a5\u53e3\u76f4\u63a5\u8fd4\u56de\u7ea6\u5b9a\u7684null2.\u5982\u679c\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u6ca1\u6709\u5305\u542b\u7ba1\u7406\u5458\u6743\u9650\uff0c\u90a3\u4e48\u5c31\u4f1a\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u62e5\u6709\u7684\u6240\u6709\u529f\u80fd\u96c6\u6ce8\uff1a\u8fd9\u91cc\u53ef\u80fd\u4f1a\u5b58\u5728\u5f53\u524d\u7528\u6237\u8fd8\u672a\u5206\u914d\u529f\u80fd\u6743\u9650\u7684\u60c5\u51b5\uff0c\u5982\u679c\u5728\u8fd9\u91cc\u6ca1\u6709\u53d1\u73b0\u529f\u80fd\u96c6competences\u6709\u503c\uff0c\u90a3\u4e48\u8fd9\u91cc\u5c31\u4f1a\u8fd4\u56de\u4e00\u4e2a\u7a7a\u7684\u529f\u80fd\u6570\u7ec43.\u67e5\u8be2\u6307\u5b9a\u7236\u7ea7\u529f\u80fd\u4e0b\uff0c\u80fd\u591f\u88ab\u8fd9\u4e9b\u89d2\u8272\u8bbf\u95ee\u7684viewItem\u4e3atrue\u7684\uff0c\u5904\u4e8e\u6b63\u5e38\u72b6\u6001\u7684\u529f\u80fd", notes="\u5982\u679c\u6ca1\u6709\u4f20\u5165parentId\u4fe1\u606f\uff0c\u5219\u8ba4\u4e3a\u662f\u9488\u5bf9\u6839\u7ea7\u529f\u80fd\u505a\u4ee5\u4e0a\u67e5\u8be2\u3002\u5e76\u4e14\u53ea\u663e\u793a\u72b6\u6001\u6b63\u786e\u7684\u90a3\u4e9b\u529f\u80fd")
    @RequestMapping(value={"/findByCurrentUser"}, method={RequestMethod.GET})
    public ResponseModel findByCurrentUser(@RequestParam(name="viewItem") @ApiParam(name="viewItem", value="\u662f\u5426\u662f\u529f\u80fd\u83dc\u5355\u4e0a\u7684\u529f\u80fd\u680f\u76ee1\uff1a\u9700\u8981\u663e\u793a\u7684\uff1b0\uff1a\u4e0d\u9700\u8981\u663e\u793a\u7684") Boolean viewItem) {
        try {
            UserVo currentUser = this.userService.findByAccount(this.getPrincipalAccount());
            Validate.notNull((Object)currentUser, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            List roles = this.roleService.findAllByUserId(currentUser.getId(), Integer.valueOf(0));
            Validate.notNull((Object)roles, (String)"\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u4efb\u4f55\u89d2\u8272\u5c5e\u6027\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            List<String> roleNames = roles.stream().map(RoleVo::getRoleName).collect(Collectors.toList());
            JSONArray competences = this.competenceService.findByViewItemAndRoleNamesAndStatus(viewItem, roleNames.toArray(new String[0]), Integer.valueOf(1));
            return this.buildHttpResult(competences);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u7684\u89d2\u8272Name\u67e5\u8be2\u5df2\u7ed1\u5b9a\u7684\u529f\u80fd\u4fe1\u606f\uff0c\u4e14\u8fd9\u4e9b\u529f\u80fd\u72b6\u6001\u7b26\u5408\u67e5\u8be2\u7684\u8981\u6c42\uff0c\u6ce8\uff1a1.\u8be5\u63a5\u53e3\u4f1a\u5bf9\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u540d\u79f0\u4e0eyml\u914d\u7f6e\u7684\u7ba1\u7406\u5458\u89d2\u8272\u4fe1\u606f\u53d6\u4ea4\u96c6\uff0c\u5224\u5b9a\u662f\u5426\u5177\u6709\u7ba1\u7406\u5458\u89d2\u8272,\u5982\u679c\u5177\u6709\u7ba1\u7406\u5458\u6743\u9650\uff0c\u8be5\u63a5\u53e3\u76f4\u63a5\u8fd4\u56de\u7ea6\u5b9a\u7684null2.\u5982\u679c\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u6ca1\u6709\u5305\u542b\u7ba1\u7406\u5458\u6743\u9650\uff0c\u90a3\u4e48\u5c31\u4f1a\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u62e5\u6709\u7684\u6240\u6709\u529f\u80fd\u96c6\u6ce8\uff1a\u8fd9\u91cc\u53ef\u80fd\u4f1a\u5b58\u5728\u5f53\u524d\u7528\u6237\u8fd8\u672a\u5206\u914d\u529f\u80fd\u6743\u9650\u7684\u60c5\u51b5\uff0c\u5982\u679c\u5728\u8fd9\u91cc\u6ca1\u6709\u53d1\u73b0\u529f\u80fd\u96c6competences\u6709\u503c\uff0c\u90a3\u4e48\u8fd9\u91cc\u5c31\u4f1a\u8fd4\u56de\u4e00\u4e2a\u7a7a\u7684\u529f\u80fd\u6570\u7ec43.\u67e5\u8be2\u6307\u5b9a\u7236\u7ea7\u529f\u80fd\u4e0b\uff0c\u80fd\u591f\u88ab\u8fd9\u4e9b\u89d2\u8272\u8bbf\u95ee\u7684viewItem\u4e3atrue\u7684\uff0c\u5904\u4e8e\u6b63\u5e38\u72b6\u6001\u7684\u529f\u80fd")
    @RequestMapping(value={"/findByRoleNamesAndStatus"}, method={RequestMethod.GET})
    public ResponseModel findByRoleNameAndStatus(@RequestParam(name="viewItem") @ApiParam(name="viewItem", value="\u662f\u5426\u662f\u529f\u80fd\u83dc\u5355\u4e0a\u7684\u529f\u80fd\u680f\u76ee1\uff1a\u9700\u8981\u663e\u793a\u7684\uff1b0\uff1a\u4e0d\u9700\u8981\u663e\u793a\u7684") Boolean viewItem, @RequestParam(name="roleNames") @ApiParam(name="roleNames", value="\u6307\u5b9a\u7684\u89d2\u8272name\uff08\u53ef\u4ee5\u662f\u591a\u4e2a\uff09\uff0c\u5982\u662fADMIN\u3001VISITOR") String[] roleNames, @RequestParam(name="status", required=false) @ApiParam(name="status", value="\u72b6\u6001\uff081\u6b63\u5e38/0\u7981\u7528\uff09\uff0c\u8fd9\u4e2a\u72b6\u6001\u4fe1\u606f\u4e0d\u7528\u5fc5\u987b\uff0c\u5982\u679c\u4e0d\u4f20\u5165\u5219\u8868\u793a\u65e0\u8bba\u529f\u80fd\u5904\u4e8e\u4f55\u79cd\u72b6\u6001\uff0c\u90fd\u6ee1\u8db3\u67e5\u8be2\u8981\u6c42", required=false) Integer status) {
        try {
            JSONArray competences = this.competenceService.findByViewItemAndRoleNamesAndStatus(viewItem, roleNames, status);
            return this.buildHttpResult(competences);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8fd9\u91cc\u53ea\u51c6\u5bf9\u529f\u80fd\u4fe1\u606f\u4e2dviewItem\u4e3afalse\u7684\u4fe1\u606f\u8fdb\u884c\u5206\u9875\u67e5\u8be2\u5904\u7406\uff08\u67e5\u8be2\u6761\u4ef6\u4e5f\u53ea\u6709\u529f\u80fd\u540d\uff09\uff0c\u4e14\u67e5\u8be2\u7684\u7ed3\u679c\uff0c\u53ea\u6709\u529f\u80fd\u7684\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@RequestParam(name="comment", required=false) @ApiParam(name="comment", value="\u53ef\u80fd\u5b58\u5728\u7684\u529f\u80fd\u540d\uff08\u529f\u80fd\u5907\u6ce8\uff09 ", required=false) String comment, @PageableDefault(value=50) @ApiParam(name="pageable", value="\u5206\u9875\u53c2\u6570\uff0c\u5f53\u6307\u5b9apage\u65f6\u4e3a\u67e5\u8be2\u5f53\u524d\u9875\u7801\uff08\u9875\u7801\u4ece0\u5f00\u59cb\uff09\uff1b\u5f53\u6307\u5b9asize\u65f6\uff0c\u4e3a\u6307\u5b9a\u6bcf\u9875\u5927\u5c0f\uff0c\u9ed8\u8ba4\u4e3a50") Pageable pageable) {
        try {
            Page results = this.competenceService.findByConditions(comment, pageable);
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

