/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.RoleEntity;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="RoleRepository")
public interface RoleRepository
extends JpaRepository<RoleEntity, String>,
JpaSpecificationExecutor<RoleEntity> {
    @Modifying
    @Query(value="delete from engine_role_user_mapping where user_id = :userId", nativeQuery=true)
    public void deleteRoleByUserId(@Param(value="userId") String var1);

    @Modifying
    @Query(value="insert into engine_role_user_mapping(role_id , user_id) values (:roleId , :userId)", nativeQuery=true)
    public void bindUser(@Param(value="userId") String var1, @Param(value="roleId") String var2);

    @Modifying
    @Query(value="insert into engine_role_competence_mapping(role_id , competence_id) values (:roleId , :competenceId)", nativeQuery=true)
    public void bindCompetence(@Param(value="competenceId") String var1, @Param(value="roleId") String var2);

    public List<RoleEntity> findByTstatus(@Param(value="useStatus") Integer var1);

    public RoleEntity findByRoleCode(String var1);

    @Query(value="select distinct r from RoleEntity r left join fetch r.users a where a.id = :userId")
    public List<RoleEntity> findByUserId(@Param(value="userId") String var1);

    @Query(value="select distinct r from RoleEntity r left join fetch r.competences c where c.id = :competenceId")
    public List<RoleEntity> findByCompetenceId(@Param(value="competenceId") String var1);

    public RoleEntity findByRoleName(String var1);

    @Query(value="from RoleEntity m where m.id in :ids")
    public Set<RoleEntity> findByIds(@Param(value="ids") List<String> var1);

    public Set<RoleEntity> findByParentIsNull();

    @Query(value="select u from RoleEntity u where u.roleName like CONCAT(CONCAT('%',:roleName),'%')")
    public Set<RoleEntity> findByRoleNameLike(@Param(value="roleName") String var1);

    @Query(value="select distinct r from RoleEntity r left join fetch r.positions a where a.id = :positionId")
    public Set<RoleEntity> findByPosition(@Param(value="positionId") String var1);

    @Query(value="select distinct r from RoleEntity r left join fetch r.positions a where a.id in :positionIds")
    public Set<RoleEntity> findByPositions(@Param(value="positionIds") List<String> var1);
}

