/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.service.invoke.model.InvokeOperations;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

class SQLOrderbyAnalysis {
    private SQLOrderbyAnalysis() {
    }

    static void buildSQLConditionsOrderBy(Set<DataViewFilterEntity> filters, InvokeParams params, Map<SQLCorrelationEnum, Object> map) {
        if (CollectionUtils.isEmpty(filters) || CollectionUtils.isEmpty(map)) {
            return;
        }
        Set orderBySets = filters.stream().filter(e -> {
            String fieldName = e.getField().getFieldName();
            InvokeOperations model = params.get(fieldName);
            return params.containsKey(fieldName) && StringUtils.isNotBlank((CharSequence)model.getSortType());
        }).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(orderBySets)) {
            return;
        }
        StringBuilder orderByBuilder = new StringBuilder(" order by ");
        for (DataViewFilterEntity e2 : orderBySets) {
            String fieldName = e2.getField().getFieldName();
            InvokeOperations model = params.get(fieldName);
            model.setOprtType(e2.getOpType());
            model.setParamName(fieldName);
            orderByBuilder.append(String.format(" %s.%s %s,", "s01y01s01", model.getParamName(), model.getSortType()));
        }
        String orderBy = StringUtils.left((String)orderByBuilder.toString(), (int)(orderByBuilder.toString().length() - 1));
        String oldVal = map.remove((Object)SQLCorrelationEnum.RESULT_SQL).toString();
        map.putIfAbsent(SQLCorrelationEnum.PRE_ORDER_PAGE_SQL, oldVal);
        String newVal = oldVal + orderBy;
        map.put(SQLCorrelationEnum.RESULT_SQL, newVal);
    }
}

