/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.core.entity.RemoteServiceEntity;
import com.bizunited.platform.core.repository.internal.PageRepositoryImpl;
import com.bizunited.platform.core.repository.internal.RemoteServiceRepositoryCustom;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="RemoteServiceRepositoryImpl")
public class RemoteServiceRepositoryImpl
implements RemoteServiceRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String REMOTE_SERVICE_TYPE = "remoteServiceType";
    private static final String ADDRESS_CODE = "addressCode";
    private static final String ADDRESS_ALIAS = "addressAlias";
    private static final String REQUEST_METHOD = "requestMethod";
    private static final String REMOTE_SERVICE_STATUS = "remoteServiceStatus";

    @Override
    public Page<RemoteServiceEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
        Object remoteServiceStatus;
        Object requestMethod;
        Object addressAlias;
        Object addressCode;
        StringBuilder hql = new StringBuilder("select u from RemoteServiceEntity u inner join fetch u.remoteServiceAddress r where 1 = 1");
        StringBuilder countHql = new StringBuilder("select count(*) from RemoteServiceEntity u inner join u.remoteServiceAddress r where 1 = 1");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameter = new HashMap<String, Object>(8);
        Object remoteServiceType = conditions.get(REMOTE_SERVICE_TYPE);
        if (remoteServiceType != null) {
            condition.append(" AND u.remoteServiceType = :remoteServiceType ");
            parameter.put(REMOTE_SERVICE_TYPE, remoteServiceType);
        }
        if ((addressCode = conditions.get(ADDRESS_CODE)) != null) {
            condition.append(" AND r.code = :addressCode ");
            parameter.put(ADDRESS_CODE, addressCode);
        }
        if ((addressAlias = conditions.get(ADDRESS_ALIAS)) != null) {
            condition.append(" AND r.alias = :addressAlias ");
            parameter.put(ADDRESS_ALIAS, addressAlias);
        }
        if ((requestMethod = conditions.get(REQUEST_METHOD)) != null) {
            condition.append(" AND u.requestMethod = :requestMethod ");
            parameter.put(REQUEST_METHOD, requestMethod);
        }
        if ((remoteServiceStatus = conditions.get(REMOTE_SERVICE_STATUS)) != null) {
            condition.append(" AND u.remoteServiceStatus = :remoteServiceStatus ");
            parameter.put(REMOTE_SERVICE_STATUS, remoteServiceStatus);
        }
        hql.append((CharSequence)condition);
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameter, pageable);
    }
}

