/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalRelationEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.OrganizationEntity;
import com.bizunited.platform.core.entity.PositionEntity;
import com.bizunited.platform.core.entity.RoleEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UserGroupEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.repository.dataview.DataViewAuthVerticalRepository;
import com.bizunited.platform.core.repository.dataview.DataViewRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalRelationService;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalService;
import com.bizunited.platform.rbac.server.service.OrganizationService;
import com.bizunited.platform.rbac.server.service.PositionService;
import com.bizunited.platform.rbac.server.service.RoleService;
import com.bizunited.platform.rbac.server.service.UserGroupService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.OrganizationVo;
import com.bizunited.platform.rbac.server.vo.PositionVo;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.rbac.server.vo.UserGroupVo;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewAuthVerticalServiceImpl")
public class DataViewAuthVerticalServiceImpl
implements DataViewAuthVerticalService {
    @Autowired
    private DataViewRepository dataViewRepository;
    @Autowired
    private DataViewAuthVerticalRepository dataViewAuthVerticalRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private DataViewAuthVerticalRelationService dataViewAuthVerticalRelationService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public Set<DataViewAuthVerticalEntity> create(Set<DataViewAuthVerticalEntity> authVerticals) {
        Validate.notEmpty(authVerticals, (String)"\u65b0\u589e\u65f6\uff0c\u4f20\u5165\u7684\u7eb5\u5411\u6743\u9650\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (DataViewAuthVerticalEntity e2 : authVerticals) {
            this.createValidation(e2);
        }
        this.dataViewAuthVerticalRepository.saveAll(authVerticals);
        Set auths = authVerticals.stream().filter(e -> e.getParamSourceType() == 2).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(auths)) {
            for (DataViewAuthVerticalEntity e3 : auths) {
                Set<DataViewAuthVerticalRelationEntity> authRelations = e3.getAuthRelations();
                this.dataViewAuthVerticalRelationService.create(e3, authRelations);
            }
        }
        return authVerticals;
    }

    @Override
    public void createValidation(DataViewAuthVerticalEntity dataViewAuthVerticalEntity) {
        Validate.notNull((Object)dataViewAuthVerticalEntity, (String)"\u7eb5\u5411\u6570\u636e\u6743\u9650\u7684\u5bf9\u8c61\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewAuthVerticalEntity.getId()), (String)"\u6dfb\u52a0\u7eb5\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewAuthVerticalEntity.setId(null);
        Validate.notNull((Object)dataViewAuthVerticalEntity.getParamSourceType(), (String)"\u53c2\u6570\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthVerticalEntity.getAuthType(), (String)"\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthVerticalEntity.getOprtType(), (String)"\u64cd\u4f5c\u7b26\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DataViewEntity dataView = dataViewAuthVerticalEntity.getDataView();
        Validate.notNull((Object)dataView, (String)"\u6dfb\u52a0\u7eb5\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<DataViewFieldEntity> displayFields = dataViewAuthVerticalEntity.getDisplayFields();
        Validate.notEmpty(displayFields, (String)"\u663e\u793a\u5b57\u6bb5\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        switch (dataViewAuthVerticalEntity.getParamSourceType()) {
            case 1: {
                Validate.isTrue((boolean)CollectionUtils.isEmpty(dataViewAuthVerticalEntity.getAuthRelations()), (String)"\u6dfb\u52a0\u7eb5\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\u4e14\u53c2\u6570\u6765\u6e90\u4e0d\u662f\u56fa\u5b9a\u503c\uff0c\u6743\u9650\u5173\u7cfb\u5fc5\u987b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                Validate.notNull((Object)dataViewAuthVerticalEntity.getField(), (String)"\u6dfb\u52a0\u7eb5\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\u4e14\u53c2\u6570\u6765\u6e90\u662f\u5916\u90e8\u4f20\u5165\u65b9\u5f0f\uff0c\u6307\u5b9a\u7684\u6743\u9650\u5b57\u6bb5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                break;
            }
            case 3: {
                Validate.isTrue((dataViewAuthVerticalEntity.getParamSourceType() != 3 ? 1 : 0) != 0, (String)"\u7eb5\u5411\u6570\u636e\u6743\u9650\u53c2\u6570\u6765\u6e90\u6ca1\u6709\u9884\u5236\u503c\u65b9\u5f0f\uff01\uff01", (Object[])new Object[0]);
                break;
            }
        }
    }

    @Override
    @Transactional
    public Set<DataViewAuthVerticalEntity> update(Set<DataViewAuthVerticalEntity> authVerticals, String dataViewId) {
        Validate.notBlank((CharSequence)dataViewId, (String)"\u66f4\u65b0\u65f6\uff0c\u4f20\u5165\u7684\u89c6\u56feID\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01", (Object[])new Object[0]);
        Optional op = this.dataViewRepository.findById(dataViewId);
        DataViewEntity dataViewEntity = op.orElse(null);
        Validate.notNull((Object)dataViewEntity, (String)"\u6839\u636e\u89c6\u56feID\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u76f8\u5e94\u7684\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(authVerticals)) {
            Set<DataViewAuthVerticalEntity> authVers = this.dataViewAuthVerticalRepository.findDetailsByDataViewCode(dataViewEntity.getCode());
            if (!CollectionUtils.isEmpty(authVers)) {
                for (DataViewAuthVerticalEntity x : authVers) {
                    this.dataViewAuthVerticalRelationService.deleteByAuthVertical(x.getId());
                }
                this.dataViewAuthVerticalRepository.deleteByDataView(dataViewId);
            }
            return Sets.newHashSet();
        }
        Set<DataViewAuthVerticalEntity> needInsertSets = authVerticals.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toSet());
        Set needUpdateSets = authVerticals.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getId())).collect(Collectors.toSet());
        Set<DataViewAuthVerticalEntity> dbAuthVerticals = this.dataViewAuthVerticalRepository.findDetailsByDataViewCode(dataViewEntity.getCode());
        Set<String> needDeleteFieldKeys = this.nebulaToolkitService.collectionDiffent(dbAuthVerticals, authVerticals, UuidEntity::getId);
        if (!CollectionUtils.isEmpty(needInsertSets)) {
            needInsertSets.forEach(h -> h.setDataView(dataViewEntity));
            this.create(needInsertSets);
        }
        if (!CollectionUtils.isEmpty(needDeleteFieldKeys)) {
            for (String authVerticalKey : needDeleteFieldKeys) {
                this.dataViewAuthVerticalRelationService.deleteByAuthVertical(authVerticalKey);
                this.dataViewAuthVerticalRepository.deleteById(authVerticalKey);
            }
        }
        if (CollectionUtils.isEmpty(needUpdateSets)) {
            return authVerticals;
        }
        for (DataViewAuthVerticalEntity e2 : needUpdateSets) {
            this.updateValidation(e2);
            this.updateDisplayFields(e2, dbAuthVerticals);
            String currentId = e2.getId();
            Optional opt = this.dataViewAuthVerticalRepository.findById(currentId);
            DataViewAuthVerticalEntity currentDataViewAuthVerticalEntity = opt.orElse(null);
            Validate.notNull((Object)currentDataViewAuthVerticalEntity, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
            currentDataViewAuthVerticalEntity.setAuthType(e2.getAuthType());
            currentDataViewAuthVerticalEntity.setOprtType(e2.getOprtType());
            currentDataViewAuthVerticalEntity.setDataView(e2.getDataView());
            currentDataViewAuthVerticalEntity.setSortIndex(e2.getSortIndex());
            if (e2.getParamSourceType() != 2) {
                e2.setAuthRelations(null);
            }
            this.dataViewAuthVerticalRepository.save(currentDataViewAuthVerticalEntity);
            HashSet authRelations = e2.getAuthRelations();
            if (CollectionUtils.isEmpty(authRelations) || e2.getParamSourceType() == 3) {
                authRelations = Sets.newHashSet();
            }
            this.dataViewAuthVerticalRelationService.save(currentDataViewAuthVerticalEntity, authRelations);
        }
        return authVerticals;
    }

    private void updateDisplayFields(DataViewAuthVerticalEntity e, Set<DataViewAuthVerticalEntity> dbAuthVerticals) {
        Set<DataViewFieldEntity> displayFieldsNeedUpdateSets = e.getDisplayFields();
        dbAuthVerticals.stream().filter(item -> item.getId().equals(e.getId())).forEach(entity -> {
            Set<DataViewFieldEntity> displayFieldsDbAuthVerticals = entity.getDisplayFields();
            Set<String> needDeleteDisplayFields = this.nebulaToolkitService.collectionDiffent(displayFieldsDbAuthVerticals, displayFieldsNeedUpdateSets, UuidEntity::getId);
            Set<String> needInsertDisplayFields = this.nebulaToolkitService.collectionDiffent(displayFieldsNeedUpdateSets, displayFieldsDbAuthVerticals, UuidEntity::getId);
            if (!CollectionUtils.isEmpty(needDeleteDisplayFields)) {
                needDeleteDisplayFields.forEach(item -> this.dataViewAuthVerticalRepository.deleteByDisplayFieldIdAndAuthVerticalId((String)item, entity.getId()));
            }
            if (!CollectionUtils.isEmpty(needInsertDisplayFields)) {
                needInsertDisplayFields.forEach(item -> this.dataViewAuthVerticalRepository.saveByDisplayFieldIdAndAuthVerticalId((String)item, entity.getId()));
            }
        });
    }

    @Override
    public void updateValidation(DataViewAuthVerticalEntity dataViewAuthVerticalEntity) {
        Validate.notNull((Object)dataViewAuthVerticalEntity, (String)"\u66f4\u65b0\u65f6\uff0c\u7eb5\u5411\u6743\u9650\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff01\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dataViewAuthVerticalEntity.getId()), (String)"\u4fee\u6539\u7eb5\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthVerticalEntity.getParamSourceType(), (String)"\u53c2\u6570\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthVerticalEntity.getAuthType(), (String)"\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthVerticalEntity.getOprtType(), (String)"\u64cd\u4f5c\u7b26\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthVerticalEntity.getSortIndex(), (String)"\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DataViewEntity dataView = dataViewAuthVerticalEntity.getDataView();
        Validate.notNull((Object)dataView, (String)"\u66f4\u65b0\u7eb5\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        switch (dataViewAuthVerticalEntity.getParamSourceType()) {
            case 1: {
                Validate.isTrue((boolean)CollectionUtils.isEmpty(dataViewAuthVerticalEntity.getAuthRelations()), (String)"\u66f4\u65b0\u7eb5\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\u4e14\u53c2\u6570\u6765\u6e90\u4e0d\u662f\u56fa\u5b9a\u503c\uff0c\u6743\u9650\u5173\u7cfb\u5fc5\u987b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                Validate.notNull((Object)dataViewAuthVerticalEntity.getField(), (String)"\u66f4\u65b0\u7eb5\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\u4e14\u53c2\u6570\u6765\u6e90\u662f\u5916\u90e8\u4f20\u5165\u65b9\u5f0f\uff0c\u6307\u5b9a\u7684\u6743\u9650\u5b57\u6bb5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                break;
            }
            case 3: {
                Validate.isTrue((dataViewAuthVerticalEntity.getParamSourceType() != 3 ? 1 : 0) != 0, (String)"\u7eb5\u5411\u6570\u636e\u6743\u9650\u53c2\u6570\u6765\u6e90\u6ca1\u6709\u9884\u5236\u503c\u65b9\u5f0f\uff01\uff01", (Object[])new Object[0]);
                break;
            }
        }
    }

    @Override
    public Set<DataViewAuthVerticalEntity> findDetailsByDataViewCode(String dataView) {
        if (StringUtils.isBlank((CharSequence)dataView)) {
            return Sets.newHashSet();
        }
        Set<DataViewAuthVerticalEntity> auths = this.dataViewAuthVerticalRepository.findDetailsByDataViewCode(dataView);
        Collection<DataViewAuthVerticalEntity> collection = this.nebulaToolkitService.copyCollectionByWhiteList(auths, DataViewAuthVerticalEntity.class, DataViewAuthVerticalEntity.class, LinkedHashSet.class, ArrayList.class, "authRelations", "authRelations.authVertical", "displayFields", "dataView", "field");
        this.loadRelation(collection);
        return (Set)collection;
    }

    private void loadRelation(Collection<DataViewAuthVerticalEntity> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return;
        }
        for (DataViewAuthVerticalEntity horizontal : collection) {
            Set<DataViewAuthVerticalRelationEntity> authRelations = horizontal.getAuthRelations();
            if (CollectionUtils.isEmpty(authRelations)) continue;
            for (DataViewAuthVerticalRelationEntity authRelation : authRelations) {
                UuidEntity relation = this.getRelation(horizontal, authRelation);
                authRelation.setRelation(relation);
            }
        }
    }

    private UuidEntity getRelation(DataViewAuthVerticalEntity horizontal, DataViewAuthVerticalRelationEntity authRelation) {
        if (StringUtils.isBlank((CharSequence)authRelation.getAuthRelationIds())) {
            return null;
        }
        UuidEntity relation = null;
        switch (horizontal.getAuthType()) {
            case 1: {
                UserVo user = this.userService.findByAccount(authRelation.getAuthRelationIds());
                if (user == null) break;
                relation = this.nebulaToolkitService.copyObjectByWhiteList(user, UserEntity.class, HashSet.class, ArrayList.class, new String[0]);
                break;
            }
            case 2: {
                RoleVo role = this.roleService.findByCode(authRelation.getAuthRelationIds());
                if (role == null) break;
                relation = this.nebulaToolkitService.copyObjectByWhiteList(role, RoleEntity.class, HashSet.class, ArrayList.class, new String[0]);
                break;
            }
            case 3: {
                PositionVo position = this.positionService.findByCode(authRelation.getAuthRelationIds());
                if (position == null) break;
                relation = this.nebulaToolkitService.copyObjectByWhiteList(position, PositionEntity.class, HashSet.class, ArrayList.class, new String[0]);
                break;
            }
            case 4: {
                UserGroupVo userGroup = this.userGroupService.findByGroupName(authRelation.getAuthRelationIds());
                if (userGroup == null) break;
                relation = this.nebulaToolkitService.copyObjectByWhiteList(userGroup, UserGroupEntity.class, HashSet.class, ArrayList.class, new String[0]);
                break;
            }
            case 5: {
                OrganizationVo organization = this.organizationService.findByCode(authRelation.getAuthRelationIds());
                if (organization == null) break;
                relation = this.nebulaToolkitService.copyObjectByWhiteList(organization, OrganizationEntity.class, HashSet.class, ArrayList.class, new String[0]);
                break;
            }
        }
        return relation;
    }

    @Override
    public Set<DataViewAuthVerticalEntity> findDetailsByDataViewIds(String[] dataViewIds) {
        if (dataViewIds == null || dataViewIds.length == 0) {
            return Sets.newHashSet();
        }
        Set<DataViewAuthVerticalEntity> auths = this.dataViewAuthVerticalRepository.findDetailsByDataViewIds(dataViewIds);
        Collection<DataViewAuthVerticalEntity> collection = this.nebulaToolkitService.copyCollectionByWhiteList(auths, DataViewAuthVerticalEntity.class, DataViewAuthVerticalEntity.class, HashSet.class, ArrayList.class, "authRelations", "authRelations.authVertical", "displayFields", "dataView", "field");
        return (Set)collection;
    }

    @Override
    public DataViewAuthVerticalEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewAuthVerticalRepository.findDetailsById(id);
    }

    @Override
    public DataViewAuthVerticalEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dataViewAuthVerticalRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewAuthVerticalRepository.findById(id);
        op.ifPresent(dataViewAuthVerticalEntity -> this.dataViewAuthVerticalRepository.delete(dataViewAuthVerticalEntity));
    }

    @Override
    @Transactional
    public void deleteByDataView(DataViewEntity dataViewEntity) {
        Validate.notNull((Object)dataViewEntity, (String)"\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Set<DataViewAuthVerticalEntity> vers = this.dataViewAuthVerticalRepository.findDetailsByDataViewCode(dataViewEntity.getCode());
        if (!CollectionUtils.isEmpty(vers)) {
            for (DataViewAuthVerticalEntity v : vers) {
                this.dataViewAuthVerticalRelationService.deleteByAuthVertical(v.getId());
            }
            this.dataViewAuthVerticalRepository.deleteByDataView(dataViewEntity.getId());
        }
    }
}

