/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.repository.dataview.DataViewSystemRepository;
import com.bizunited.platform.core.service.dataview.DataViewSystemService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewSystemEntityServiceImpl")
public class DataViewSystemServiceImpl
implements DataViewSystemService {
    @Autowired
    private DataViewSystemRepository dataViewSystemEntityRepository;

    @Override
    public void createValidation(DataViewSystemEntity dataViewSystemEntity) {
        Validate.notNull((Object)dataViewSystemEntity, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewSystemEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewSystemEntity.setId(null);
        Validate.notBlank((CharSequence)dataViewSystemEntity.getParamName(), (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewSystemEntity.getParamType(), (String)"\u53c2\u6570\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewSystemEntity.getParamName() == null || dataViewSystemEntity.getParamName().length() < 64 ? 1 : 0) != 0, (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewSystemEntity.getParamKey() == null || dataViewSystemEntity.getParamKey().length() < 64 ? 1 : 0) != 0, (String)"\u9884\u5236\u503c\u6807\u8bc6,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewSystemEntity.getParamValue() == null || dataViewSystemEntity.getParamValue().length() < 256 ? 1 : 0) != 0, (String)"\u5177\u4f53\u7684\u56fa\u5b9a\u503c,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DataViewSystemEntity create(DataViewSystemEntity dataViewSystemEntity, boolean ignoreValidate) {
        if (!ignoreValidate) {
            this.createValidation(dataViewSystemEntity);
        }
        this.dataViewSystemEntityRepository.save(dataViewSystemEntity);
        return dataViewSystemEntity;
    }

    @Override
    @Transactional
    public DataViewSystemEntity update(DataViewSystemEntity dataViewSystemEntity) {
        this.updateValidation(dataViewSystemEntity);
        String currentId = dataViewSystemEntity.getId();
        Optional op = this.dataViewSystemEntityRepository.findById(currentId);
        DataViewSystemEntity currentDataViewSystemEntity = op.orElse(null);
        Validate.notNull((Object)currentDataViewSystemEntity, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        currentDataViewSystemEntity.setParamName(dataViewSystemEntity.getParamName());
        currentDataViewSystemEntity.setParamType(dataViewSystemEntity.getParamType());
        currentDataViewSystemEntity.setParamKey(dataViewSystemEntity.getParamKey());
        currentDataViewSystemEntity.setParamValue(dataViewSystemEntity.getParamValue());
        currentDataViewSystemEntity.setParamSourceType(dataViewSystemEntity.getParamSourceType());
        this.dataViewSystemEntityRepository.save(currentDataViewSystemEntity);
        return currentDataViewSystemEntity;
    }

    @Override
    public void updateValidation(DataViewSystemEntity dataViewSystemEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dataViewSystemEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewSystemEntity.getParamName(), (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewSystemEntity.getParamType(), (String)"\u53c2\u6570\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewSystemEntity.getParamName() == null || dataViewSystemEntity.getParamName().length() < 64 ? 1 : 0) != 0, (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewSystemEntity.getParamKey() == null || dataViewSystemEntity.getParamKey().length() < 64 ? 1 : 0) != 0, (String)"\u9884\u5236\u503c\u6807\u8bc6,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewSystemEntity.getParamValue() == null || dataViewSystemEntity.getParamValue().length() < 256 ? 1 : 0) != 0, (String)"\u5177\u4f53\u7684\u56fa\u5b9a\u503c,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public List<DataViewSystemEntity> findByDataView(String dataViewId) {
        if (StringUtils.isBlank((CharSequence)dataViewId)) {
            return Lists.newArrayList();
        }
        return this.dataViewSystemEntityRepository.findByDataView(dataViewId);
    }

    @Override
    public DataViewSystemEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewSystemEntityRepository.findDetailsById(id);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewSystemEntityRepository.findById(id);
        op.ifPresent(dataViewSystemEntity -> this.dataViewSystemEntityRepository.deleteById(id));
    }

    @Override
    @Transactional
    public void create(Set<DataViewSystemEntity> systemFilters, DataViewEntity dataViewEntity) {
        Validate.notNull((Object)dataViewEntity, (String)"\u6570\u636e\u89c6\u56fe\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(systemFilters)) {
            systemFilters.forEach(e -> {
                this.createValidation((DataViewSystemEntity)e);
                e.setDataView(dataViewEntity);
            });
        }
        if (!CollectionUtils.isEmpty(systemFilters)) {
            this.dataViewSystemEntityRepository.saveAll(systemFilters);
        }
    }
}

