package com.bizunited.platform.core.common.enums;

/**
 * 用于SQL相关的常量信息
 */
public enum SQLCorrelationEnum {
  /**存储各分析过程中的结果SQL   用于SQL的存储*/
  RESULT_SQL("resultSQL"),
  /**存储filter筛选条件(where)的参数值    用于数据视图参数解析*/
  CONDITION_VALUES("conditionValues"),
  /**存储横向权限的参数值    用于数据视图参数解析*/
  AUTH_HORIZONTAL_VALUES("authHorizontalValues"),
  /**存储系统参数参数值    用于系统参数参数解析*/
  SYSTEM_PARAM_VALUES("systemParamValues"),
  /**存储纵向权限的参数值    用于数据视图参数解析*/
  AUTH_VERTICAL_VALUES("authVerticalValues"),
  /**预制值信息参数值    用于数据视图预制参数解析*/
  PRESETS("presets"),
  /**预制值信息参数值    用于数据视图系统参数中的预制参数解析*/
  SYSTEM_PRESETS("systemPresets"),
  /**预制值信息参数值    用于数据视图纵向权限中的预制参数解析*/
  VERTICAL_PRESETS("verticalPresets"),
  /**纵向权限显示字段    用于数据视图纵向权限中的显示字段*/
  DISPLAY_FIELDS("verticalDispalyFields"),
  USER_RELATION("1"),
  ROLE_RELATION("2"),
  POSITION_RELATION("3"),
  USER_GROUP_RELATION("4"),
  ORGS_RELATION("5"),
  /**记录参数下标值的计数器*/
  COUNTER("counter"),

  /**
   * 用于列表的 分页count查询， 拼接排序或分页参数前的 sql存储到这里
   *
   * 在 SQLOrderbyAnalysis#buildSQLConditionsOrderBy 或 SQLPageAnalysis#pageAnalysis 中设置
   */
  PRE_ORDER_PAGE_SQL("preOrderPageSQL"),
  ;



  /**枚举的code编码*/
  private String code;



  SQLCorrelationEnum(String code){
    this.code = code;
  }

  public String getCode() {
    return code;
  }
}
